#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
# 
#      http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'java'

#
# @author <a href="mailto:woonsan@apache.org">Woonsan Ko</a>
# @version $Id: HelloJRuby.rb 936987 2010-04-22 18:01:59Z woonsan $
#
class HelloJRuby < javax.portlet.GenericPortlet
    
    def doView(request, response)
        greeting = "<H1>" + getTitle(request) + "</H1>"
        response.writer.println(greeting)
    end
    
    def processAction(request, response)
        request.preferences.setValue("message", request.getParameter("message"))
        request.preferences.store()
    end
    
    def processEvent(request, response)
        request.getAttribute("values").put("message", "hello")
    end
    
    def serveResource(request, response)
        request.getAttribute("values").put("message", "hello")
    end
    
end

# Return portlet instance as a last evaluated object
# because ScriptPortlet expects the evaluated result object as a portlet class or non-initialized portlet instance.
HelloJRuby.new
