package org.apache.jetspeed.portlet;

import java.util.Enumeration;
import java.util.Locale;

/**
 ** The <CODE>PortletSettings</CODE> interface provides the portlet with
 ** its dynamic configuration. The configuration holds information about the
 ** portlet that is valid per concrete portlet for all users, and is maintained by the
 ** administrator. The portlet can therefore only read the dynamic configuration.
 ** Only when the portlet is in CONFIGURE mode, it has write access to
 ** the dynamic configuration data
 **
 ** @see   Portlet
 **
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 **/

public interface PortletSettings
{

    /**
     ** Returns the portlet's default locale.
     **
     ** @return  the default locale
     **/

    public Locale getDefaultLocale();

    /**
     ** Returns the title of this window. This method returns
     ** only a static title from the portlet configuration.
     **
     ** @param   locale
     **          the locale
     ** @param   client
     **          the client
     **
     ** @return   the text of the portlet title
     **/

    public String getTitle (Locale locale,
                            Client client);

    /**
     ** Sets the attribute with the given name and value.
     **
     ** @param   name
     **          the attribute name
     ** @param   value
     **          the attribute value
     **
     ** @exception   AccessDeniedException
     **              if the caller isn't authorized to access
     **              this data object
     **/

    public void setAttribute (String name, String value) throws AccessDeniedException;

    /**
     ** Returns the value of the attribute with the given name,
     ** or <CODE>null</CODE> if no such attribute exists.
     **
     ** @param   name
     **          the attribute name
     **
     ** @return   the attribute value
     **/

    public String getAttribute (String name);

    /**
     ** Returns an enumeration of all available attributes names.
     **
     ** @return   an enumeration of attribute names
     **
     ** @see   #getAttribute(String)
     **/

    public Enumeration getAttributeNames ();

    /**
     ** Removes the attribute with the given name. If no such
     ** attribute exists, this method does nothing.
     **
     ** @param   name
     **          the attribute name
     **
     ** @exception   AccessDeniedException
     **              if the caller isn't authorized to access
     **              this data object
     **/

    public void removeAttribute (String name) throws AccessDeniedException;

    /**
     ** Stores all attributes.
     **
     ** @exception   AccessDeniedException
     **              if the caller isn't authorized to access
     **              this data object
     ** @exception   java.io.IOException
     **              if the streaming causes an I/O problem
     **/

    public void store () throws AccessDeniedException, java.io.IOException;


    /**
     * Returns the portlet application settings
     * 
     * @return the portlet application settings
     */
    public PortletApplicationSettings getApplicationSettings();
}
