package org.apache.jetspeed.portlet;

import java.util.Enumeration;

/**
 ** The <CODE>User</CODE> interface is an abstract view on the
 ** user-specific data. Apart from a set of pre-defined, fixed set
 ** of attributes, the interface gives access to user data
 ** as well.
 **
 ** @author   <A HREF="mailto:tboehme@apache.org">Thomas F. Boehme</A>
 **/

public interface User
{
    /**
     ** Returns the internal unique user id.
     **
     ** @return   the internal unique user id
     **/

    public String getID ();

    /**
     ** Returns the user id of the user, or
     ** <CODE>null</CODE> if the user id is not available.
     **
     ** @return   the user id
     **/

    public String getUserID ();

    /**
     ** Returns the given (aka first) name of the user, or
     ** <CODE> if the given name is not available.
     **
     ** @return   the given name
     **/

    public String getGivenName ();

    /**
     ** Returns the family (aka last) name of the user.
     **
     ** @return   the family name
     **/

    public String getFamilyName ();

    /**
     ** Returns the full name of the user, or
     ** <CODE>null</CODE> if the full name is not available.
     **
     ** <P>
     ** The full name contains given names, family names and
     ** possibly a title or suffix. Therefore, the full name
     ** may be different from the concatenation of given and
     ** family name.
     **
     ** @return   the full name
     **/

    public String getFullName ();

    /**
     ** Returns the nick name of the user, or
     ** <CODE>null</CODE> if the nick name is not available.
     **
     ** @return   the nick name
     **/

    public String getNickName ();

    /**
     ** Returns the point of time that this user was last logged in,
     ** or <CODE>null</CODE> if this information is not available.
     ** The time is returned in number of milliseconds since
     ** January 1, 1970 GMT.
     **
     ** @return   the last login time
     **/

    public long getLastLoginTime ();

    /**
     ** Returns the value of the attribute with the given name,
     ** or <CODE>null</CODE> if no such attribute exists.
     **
     ** @param   name
     **          the attribute name
     **
     ** @return   the attribute value
     **/

    public Object getAttribute (String name);

    /**
     ** Returns an enumeration of all available attributes names.
     **
     ** @return   an enumeration of attribute names
     **/

    public Enumeration getAttributeNames ();

}
