package org.apache.jetspeed.portlet.event;

import org.apache.jetspeed.portlet.Portlet;

/**
 ** A <CODE>WindowEvent</CODE> is sent by a portlet window whenever
 ** the user or the portal interacts with its controls.
 **
 ** @see   WindowListener
 **
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 **/

public interface WindowEvent extends Event
{
    /**
     ** Event identifier indicating that a portlet window will be
     ** detached.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be detached from the rest of the portlet page.
     **/

    public final static int WINDOW_DETACHED = 1001;

    /**
     ** Event identifier indicating that a portlet window will be
     ** moved.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be moved to a different location on the
     ** page.
     **/

//    public final static int WINDOW_MOVING = 1002;

    /**
     ** Event identifier indicating that a portlet window will be
     ** resized.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be resized.
     **/

//    public final static int WINDOW_RESIZING = 1003;

    /**
     ** Event identifier indicating that a portlet window will be
     ** maximized.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be maximized.
     **/

    public final static int WINDOW_MAXIMIZED = 1004;

    /**
     ** Event identifier indicating that a portlet window will be
     ** minimized.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be minimized.
     **/

    public final static int WINDOW_MINIMIZED = 1005;

    /**
     ** Event identifier indicating that a portlet window will be
     ** restored.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be restored to its previous size.
     **/

    public final static int WINDOW_RESTORED = 1006;

    /**
     ** Event identifier indicating that a portlet window is
     ** closed.
     **
     ** <P>
     ** An event with this id is fired when the user has requested
     ** that the window be closed.
     **/

    public final static int WINDOW_CLOSED = 1007;

    /**
     * Returns the identifier of the current window event
     * 
     * @return the window event identifier
     */
    public int getEventId();
}