package org.apache.jetspeed.portletcontainer;

// jetspeed
import org.apache.jetspeed.portlet.*;

import com.ibm.wps.util.ObjectID;

// java
import java.io.InputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Enumeration;
import javax.servlet.*;

/**
 **/

public class PortletNamespaceMapper
{
    public static String encode(String namespace, String name)
    {
        StringBuffer buffer = new StringBuffer("PC_");
        buffer.append(namespace);
        buffer.append('_');
        buffer.append(name);
        return buffer.toString();
    }

    public static String encode(ObjectID namespace, String name)
    {
        StringBuffer buffer = new StringBuffer("PC_");
        buffer.append(namespace.intValue());
        buffer.append('_');
        buffer.append(name);
        return buffer.toString();
    }

    public static String encode(String namespace1, String namespace2, String name)
    {
        StringBuffer buffer = new StringBuffer("PC_");
        buffer.append(namespace1);
        buffer.append('_');
        buffer.append(namespace2);
        buffer.append('_');
        buffer.append(name);
        return buffer.toString();
    }

    public static String encode(ObjectID namespace1, ObjectID namespace2, String name)
    {
        StringBuffer buffer = new StringBuffer("PC_");
        buffer.append(namespace1.intValue());
        buffer.append('_');
        buffer.append(namespace2.intValue());
        buffer.append('_');
        buffer.append(name);
        return buffer.toString();
    }

    public static String decode(ObjectID namespace, String name)
    {
        return decode(namespace.toString(),name);
    }

    public static String decode(String namespace, String name)
    {
        StringBuffer prefix = new StringBuffer("pc_");
        prefix.append(namespace.toLowerCase());
        prefix.append('_');
        if (name.toLowerCase().startsWith(prefix.toString())) {
            return name.substring(prefix.length());
        }
        else return null;
    }

    public static String decode(ObjectID namespace1, ObjectID namespace2, String name)
    {
        return decode(namespace1.toString(),namespace2.toString(),name);
    }

    public static String decode(String namespace1, String namespace2, String name)
    {
        StringBuffer prefix = new StringBuffer("pc_");
        prefix.append(namespace1.toLowerCase());
        prefix.append('_');
        prefix.append(namespace2.toLowerCase());
        prefix.append('_');
        if (name.toLowerCase().startsWith(prefix.toString())) {
            return name.substring(prefix.length());
        }
        else return null;
    }

    public static boolean isInNamespace(String name)
    {
        StringBuffer prefix = new StringBuffer("pc_");
        if (name.toLowerCase().startsWith(prefix.toString())) return true;
        else return false;
    }

    public static boolean isInNamespace(ObjectID namespace, String name)
    {
        return isInNamespace(namespace.toString(),name);
    }
    
    public static boolean isInNamespace(String namespace, String name)
    {
        StringBuffer prefix = new StringBuffer("pc_");
        prefix.append(namespace.toLowerCase());
        prefix.append('_');
        if (name.toLowerCase().startsWith(prefix.toString())) return true;
        else return false;
    }

    public static boolean isInNamespace(ObjectID namespace1, ObjectID namespace2, String name)
    {
        return isInNamespace(namespace1.toString(),namespace2.toString(),name);
    }

    public static boolean isInNamespace(String namespace1, String namespace2, String name)
    {
        StringBuffer prefix = new StringBuffer("pc_");
        prefix.append(namespace1.toLowerCase());
        prefix.append('_');
        prefix.append(namespace2.toLowerCase());
        prefix.append('_');
        if (name.toLowerCase().startsWith(prefix.toString())) return true;
        else return false;
    }

}
