package org.apache.jetspeed.portletcontainer;

// jetspeed
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.MessageEvent;
import org.apache.jetspeed.portlet.event.MessageListener;
import org.apache.jetspeed.portletcontainer.invoker.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.util.*;

import org.apache.jetspeed.portletcontainer.om.applicationinstanceregistry.ApplicationInstanceEntry;
import org.apache.jetspeed.portletcontainer.om.portletregistry.ConcretePortletEntry;

import org.apache.turbine.util.Log;

// java
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.InputStream;
import java.io.IOException;
import java.util.*;

public class PortletSessionData implements HttpSessionBindingListener,
                                           java.io.Serializable
{
    private String caiid = null;
    private long creationTime = System.currentTimeMillis();
    private long lastAccessedTime = creationTime;

    public PortletSessionData( String caiid )
    {
        this.caiid = caiid;
        creationTime = System.currentTimeMillis();
        lastAccessedTime = creationTime;
    }

    public long getCreationTime ()
    {
        return creationTime;
    }

    public long getLastAccessedTime ()
    {
        return lastAccessedTime;
    }

    public void access( )
    {                          
        lastAccessedTime = System.currentTimeMillis();
    }

    public String getCAiid()
    {
        return this.caiid;
    }

    public ApplicationInstanceEntry getApplication(PortalInformationProvider provider)
    {
        try {
            return provider.getPortletApplicationInstanceEntry(
                new com.ibm.wps.util.ObjectID(caiid));
        }
        catch (java.io.IOException e) {
            org.apache.turbine.util.Log.error("PortletSessionData.getApplication("+caiid+") could not load the application instance.",e);
            return null;
        }
    }

    public void valueBound(HttpSessionBindingEvent event)
    {
        // do nothing
    }

    public void valueUnbound(HttpSessionBindingEvent event)
    {
        org.apache.turbine.util.Log.info("PortletSessionData.valueUnbound called for AIID="+getCAiid());

        // this object is being removed from the session
        // now we have to logout all portlets associated with it

        // create portlet session
        PortletSessionImpl portletSession = new PortletSessionImpl( this, 
                                                                    event.getSession() );

        // log out all portlets of this session

        Enumeration allPortletsInSession = Portlet.getAllPortletsLinkedWithSession(portletSession);
        while (allPortletsInSession.hasMoreElements())
        {
            Portlet.PortletSessionStub stub = 
                (Portlet.PortletSessionStub)allPortletsInSession.nextElement();
            if ((stub!=null) && (stub.getPortlet()!=null)) // if not already logged out
            {
                com.ibm.wps.portletcontainer.PortalInformationProviderImpl provider = 
                    new com.ibm.wps.portletcontainer.PortalInformationProviderImpl();
                ConcretePortletEntry concretePortletEntry = null;
                try {
                    concretePortletEntry = provider.getConcretePortletEntry(
                        new com.ibm.wps.util.ObjectID(stub.getCPid()));
                }
                catch (java.io.IOException e) {
                    org.apache.turbine.util.Log.error("PortletSessionData: Unable to load concrete portlet for PID="+stub.getCPid(),e);
                }
                try {

                    PortletSettingsImpl portletSettings = 
                        new PortletSettingsImpl(concretePortletEntry, 
                                                provider);

                    HttpServletRequest servletRequest = new InternalServletRequest(event.getSession());
                    // set attributes needed for logout
                    servletRequest.setAttribute(org.apache.jetspeed.portletcontainer.Constants.PORTLET_CPIID, stub.getCPiid());
                    servletRequest.setAttribute(org.apache.jetspeed.portlet.spi.Constants.METHOD_ID,
                                                new Integer(org.apache.jetspeed.portlet.spi.Constants.METHOD_PORTLET_LOGOUT));
                    servletRequest.setAttribute(org.apache.jetspeed.portlet.spi.Constants.PARAM_PORTLETSESSION, 
                                                portletSession);
                    servletRequest.setAttribute(org.apache.jetspeed.portlet.spi.Constants.PARAM_PORTLETSETTINGS, 
                                                portletSettings);
                    // call logout
                    stub.getPortlet().service(servletRequest,
                                              (HttpServletResponse)new com.ibm.wps.servlet.response.StoredResponse());
                }
                catch (ServletException e) {
                    String message = "PortletSessionData.valueUnbound: Portlet '"+stub.getCPid()+"' could not be logged out.";
                    Log.error( message, e );
                }
                catch (IOException e) {
                    String message = "PortletSessionData.valueUnbound: Portlet '"+stub.getCPid()+"' could not be logged out.";
                    Log.error( message, e );
                }
                catch (Throwable e) {
                    // don't let the portal crash if an error occured during logout
                    String message = "PortletSessionData.valueUnbound: Portlet '"+stub.getCPid()+"' could not be logged out.";
                    Log.error( message, e );
                }
            }
        }
            
    }

}
