package org.apache.jetspeed.portletcontainer.event;

import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;
import org.apache.jetspeed.portletcontainer.*;
import org.apache.jetspeed.portletcontainer.information.*;
import org.apache.jetspeed.portletcontainer.invoker.*;
import org.apache.jetspeed.portletcontainer.util.*;
import org.apache.jetspeed.portletcontainer.om.portletinstanceregistry.PortletInstanceEntry;

import org.apache.turbine.util.*;

import com.ibm.wps.portletcontainer.invoker.*;

import javax.servlet.http.*;

public class ActionEventImpl extends InstanceEventImpl implements ActionEvent
{
    private PortletAction action = null;

    public ActionEventImpl( PortletInstanceEntry entry,
                            PortletRequest request )
    {
        super( entry, 
               request );
    }

    public PortletAction getAction ()
    {
        return action;
    }

    // additonal methods

    public void setAction(PortletAction action)
    {
        this.action = action;
    }

    public void prepare(EventEnvironment evtEnv) throws PortletException, PortletInvokerException
    {
        PortletInvokerImpl invoker = (PortletInvokerImpl)evtEnv.getPortletInvoker();

        HttpServletRequest servletRequest = evtEnv.getServletRequest();
        
        HttpServletResponse servletResponse = evtEnv.getServletResponse();

        PortletRequestImpl portletRequest = (PortletRequestImpl)getRequest();

        PortletResponseImpl portletResponse = new PortletResponseImpl( getPortletInstanceEntry(),
                                                                       portletRequest,
                                                                       servletResponse,
                                                                       true );

        PortletConfig portletConfig = evtEnv.getPortletConfig(getPortletInstanceEntry().getConcretePortlet());

        PortletInvokerImpl.InternalPortletData data = 
            ((PortletInvokerImpl.EventEnvironmentImpl)evtEnv).getInternalPortletData(getPortletInstanceEntry().getConcretePortlet());

        try
        {
            portletRequest.setAttribute(org.apache.jetspeed.portlet.spi.Constants.PARAM_ACTION_EVENT, 
                                        this);

            // include portlet by using request dispatcher
            invoker.include (org.apache.jetspeed.portlet.spi.Constants.METHOD_PERFORM_ACTION,
                             portletRequest,
                             portletResponse,
                             servletRequest, 
                             servletResponse,data);
        }
        catch (PortletException e)
        {
            String message = "ActionEventImpl.prepare: The portlet with the name '"+
                             portletConfig.getName()+"' ("+getPortletInstanceEntry()+") failed while processing the action event.";
            Log.error(message, e);
            throw e; // rethrow
        }
        catch (java.io.IOException e)
        {
            String message = "ActionEventImpl.prepare: The portlet with the name '"+
                             portletConfig.getName()+"' ("+getPortletInstanceEntry()+") failed while processing the action event.";
            Log.error(message, e);
            throw new PortletException(e); // rethrow
        }
        
    }

}