package org.apache.jetspeed.portletcontainer.information;

import org.apache.jetspeed.portlet.*;

/**
 * The <CODE>PortletLayoutWindow</CODE> interface represents a portlet
 * window and is used to exchange informations about the portlet window
 * between layout system and portlet api implementation.<BR><BR>
 * The implementation of this class has to be implemented of the
 * layout system and passed via the <CODE>PortletInvoker</CODE> to the
 * portlet api implementation.
 * 
 * @author <A HREF="mailto:shesmer@raleigh.ibm.com">Stephan Hesmer</A>
 */
public interface PortletLayoutWindow
{

    /**
     ** Returns the current window state of this portlet
     **
     ** @return   the window state
     **/

    public PortletWindow.State getWindowState ();

}
