package org.apache.jetspeed.portletcontainer.util;

// jetspeed
import org.apache.jetspeed.portletcontainer.*;

// turbine
import org.apache.turbine.util.Log;

// java
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;

public class ThreadAttributesManager
{
    private static class ThreadLocalAttributes extends ThreadLocal
    {
        public Object initialValue()
        {
            return new HashMap();
        }

        public Object getAttribute(String name)
        {
            HashMap map = (HashMap)super.get();
            return map.get(name);
        }

        public void setAttribute(String name, Object value)
        {
            HashMap map = (HashMap)super.get();
            map.put(name, value);
        }

        public void removeAttribute(String name)
        {
            HashMap map = (HashMap)super.get();
            map.remove(name);
        }

    }

    private static ThreadLocalAttributes attributes = new ThreadLocalAttributes();

    public static Object getAttribute(String name)
    {
        return attributes.getAttribute(name);
    }

    public static void setAttribute(String name, Object value)
    {
        attributes.setAttribute(name, value);
    }

    public static void removeAttribute(String name)
    {
        attributes.removeAttribute(name);
    }

}
