/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.serializer.objects;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public class JSProcessOrder
{
    private JSMimeTypes ordererList;

    public JSProcessOrder()
    {
    }

 
    /***************************************************************************
     * SERIALIZER
     */
    private static final XMLFormat XML = new XMLFormat(JSProcessOrder.class)
    {

        public void write(Object o, OutputElement xml)
                throws XMLStreamException
        {
        	
            try
            {
            	JSProcessOrder g = (JSProcessOrder) o;
                xml.add(g.getMimeTypes());

            } catch (Exception e)
            {
                e.printStackTrace();
            }
        }

        public void read(InputElement xml, Object o)
        {
            try
            {
            	JSProcessOrder g = (JSProcessOrder) o;
                while (xml.hasNext())
                {
                    Object o1 = xml.getNext(); // mime

                    if (o1 instanceof JSMimeTypes)
                        g.ordererList = (JSMimeTypes) o1;
                }
            } catch (Exception e)
            {
                e.printStackTrace();
            }
        }
    };


    /**
     * @return Returns the mimeTypes.
     */
    public JSMimeTypes getMimeTypes()
    {
        return ordererList;
    }

    /**
     * @param mimeTypes
     *            The mimeTypes to set.
     */
    public void setMimeTypes(JSMimeTypes ordererList)
    {
        this.ordererList = ordererList;
    }

}
