/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.security.mapping.impl;

import java.util.List;

import org.apache.jetspeed.security.mapping.EntityFactory;
import org.apache.jetspeed.security.mapping.EntitySearchResultHandler;
import org.apache.jetspeed.security.mapping.model.Entity;

/**
 * @version $Id: CollectingEntitySearchResultHandler.java 930298 2010-04-02 15:39:03Z ate $
 *
 */
public class CollectingEntitySearchResultHandler extends CollectingSearchResultHandler<Entity,Object> implements EntitySearchResultHandler
{
    public CollectingEntitySearchResultHandler()
    {
    }

    public CollectingEntitySearchResultHandler(int maxSize, List<Entity> results)
    {
        super(maxSize, results);
    }

    public CollectingEntitySearchResultHandler(int maxSize)
    {
        super(maxSize);
    }

    public CollectingEntitySearchResultHandler(List<Entity> results)
    {
        super(results);
    }

    private EntityFactory entityFactory;
    
    public void setEntityFactory(EntityFactory entityFactory)
    {
        this.entityFactory = entityFactory;
    }

    protected Entity mapResult(Object result, int pageSize, int pageIndex, int index)
    {
        return entityFactory.loadEntity(result);
    }
}
