/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.om.portlet;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;

/**
 * @version $Id: Language.java 759884 2009-03-30 08:52:37Z ate $
 *
 */
public interface Language extends PortletInfo, Serializable
{
    public static final String JAVAX_PORTLET_TITLE = "javax.portlet.title";
    public static final String JAVAX_PORTLET_SHORT_TITLE = "javax.portlet.short-title";
    public static final String JAVAX_PORTLET_KEYWORDS = "javax.portlet.keywords";
    
    Locale getLocale();
    
    /**
     * @return true if this Language Locale is a supported-locale from or for the Portlet descriptor
     */
    boolean isSupportedLocale();
    void setSupportedLocale(boolean supportedLocale);
    List<String> getKeywordList();
    void setKeywords(String keywords);
}
