/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.semconv.SemanticAttributes;
import javax.annotation.Nullable;

public final class HttpExperimentalAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final HttpCommonAttributesGetter<REQUEST, RESPONSE> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new HttpExperimentalAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return new HttpExperimentalAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private HttpExperimentalAttributesExtractor(HttpCommonAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (SemconvStability.emitStableHttpSemconv()) {
            Long requestBodySize = this.requestBodySize(request);
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_REQUEST_BODY_SIZE, (Object)requestBodySize);
            if (response != null) {
                Long responseBodySize = this.responseBodySize(request, response);
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_RESPONSE_BODY_SIZE, (Object)responseBodySize);
            }
        }
    }

    @Nullable
    private Long requestBodySize(REQUEST request) {
        return HttpExperimentalAttributesExtractor.parseNumber(HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "content-length")));
    }

    @Nullable
    private Long responseBodySize(REQUEST request, RESPONSE response) {
        return HttpExperimentalAttributesExtractor.parseNumber(HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpResponseHeader(request, response, "content-length")));
    }

    @Nullable
    private static Long parseNumber(@Nullable String number) {
        if (number == null) {
            return null;
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

