/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.apache.pulsar.broker.admin.impl.PersistentTopicsBase;
import org.apache.pulsar.broker.admin.v2.PersistentTopics;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/persistent")
@Produces(value={"application/json"})
@Api(value="/persistent", description="Persistent topic admin apis", tags={"persistent topic"})
public class ExtPersistentTopics
extends PersistentTopicsBase {
    private static final Logger log = LoggerFactory.getLogger(PersistentTopics.class);

    @PUT
    @Consumes(value={"application/vnd.partitioned-topic-metadata+json"})
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Create a partitioned topic.", notes="It needs to be called before creating a producer on a partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or namespace doesn't exist"), @ApiResponse(code=406, message="The number of partitions should be more than 0 and less than or equal to maxNumPartitionsPerPartitionedTopic"), @ApiResponse(code=409, message="Partitioned topic already exist"), @ApiResponse(code=412, message="Failed Reason : Name is invalid or Namespace does not have any clusters configured"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void createPartitionedTopic(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="The metadata for the topic", required=true, type="PartitionedTopicMetadata") PartitionedTopicMetadata metadata, @QueryParam(value="createLocalTopicOnly") @DefaultValue(value="false") boolean createLocalTopicOnly) {
        try {
            this.validateNamespaceName(tenant, namespace);
            this.validateGlobalNamespaceOwnership();
            this.validatePartitionedTopicName(tenant, namespace, encodedTopic);
            this.validateTopicPolicyOperation(this.topicName, PolicyName.PARTITION, PolicyOperation.WRITE);
            this.validateCreateTopic(this.topicName);
            this.internalCreatePartitionedTopic(asyncResponse, metadata.partitions, createLocalTopicOnly, metadata.properties);
        }
        catch (Exception e) {
            log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            ExtPersistentTopics.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }
}

