/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Set;

public class PortManager {
    private static final Set<Integer> PORTS = new HashSet<Integer>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized int nextLockedFreePort() {
        int exceptionCount = 0;
        while (true) {
            try {
                while (true) {
                    ServerSocket ss = new ServerSocket(0);
                    try {
                        int port = ss.getLocalPort();
                        if (PortManager.checkPortIfLocked(port)) continue;
                        PORTS.add(port);
                        int n = port;
                        return n;
                    }
                    finally {
                        ss.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (++exceptionCount <= 100) continue;
                throw new RuntimeException("Unable to allocate socket port", e);
            }
            break;
        }
    }

    public static synchronized boolean releaseLockedPort(int lockedPort) {
        return PORTS.remove(lockedPort);
    }

    public static synchronized boolean checkPortIfLocked(int lockedPort) {
        return PORTS.contains(lockedPort);
    }
}

