/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.AbstractReplicator;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;
import org.apache.pulsar.common.stats.MetricsUtil;

public class OpenTelemetryReplicatorStats
implements AutoCloseable {
    public static final String MESSAGE_IN_COUNTER = "pulsar.broker.replication.message.incoming.count";
    private final ObservableLongMeasurement messageInCounter;
    public static final String MESSAGE_OUT_COUNTER = "pulsar.broker.replication.message.outgoing.count";
    private final ObservableLongMeasurement messageOutCounter;
    public static final String BYTES_IN_COUNTER = "pulsar.broker.replication.message.incoming.size";
    private final ObservableLongMeasurement bytesInCounter;
    public static final String BYTES_OUT_COUNTER = "pulsar.broker.replication.message.outgoing.size";
    private final ObservableLongMeasurement bytesOutCounter;
    public static final String BACKLOG_COUNTER = "pulsar.broker.replication.message.backlog.count";
    private final ObservableLongMeasurement backlogCounter;
    public static final String DELAY_GAUGE = "pulsar.broker.replication.message.backlog.age";
    private final ObservableDoubleMeasurement delayGauge;
    public static final String EXPIRED_COUNTER = "pulsar.broker.replication.message.expired.count";
    private final ObservableLongMeasurement expiredCounter;
    public static final String DROPPED_COUNTER = "pulsar.broker.replication.message.dropped.count";
    private final ObservableLongMeasurement droppedCounter;
    private final BatchCallback batchCallback;

    public OpenTelemetryReplicatorStats(PulsarService pulsar) {
        Meter meter = pulsar.getOpenTelemetry().getMeter();
        this.messageInCounter = meter.upDownCounterBuilder(MESSAGE_IN_COUNTER).setUnit("{message}").setDescription("The total number of messages received from the remote cluster through this replicator.").buildObserver();
        this.messageOutCounter = meter.upDownCounterBuilder(MESSAGE_OUT_COUNTER).setUnit("{message}").setDescription("The total number of messages sent to the remote cluster through this replicator.").buildObserver();
        this.bytesInCounter = meter.upDownCounterBuilder(BYTES_IN_COUNTER).setUnit("{By}").setDescription("The total number of messages bytes received from the remote cluster through this replicator.").buildObserver();
        this.bytesOutCounter = meter.upDownCounterBuilder(BYTES_OUT_COUNTER).setUnit("{By}").setDescription("The total number of messages bytes sent to the remote cluster through this replicator.").buildObserver();
        this.backlogCounter = meter.upDownCounterBuilder(BACKLOG_COUNTER).setUnit("{message}").setDescription("The total number of messages in the backlog for this replicator.").buildObserver();
        this.delayGauge = meter.gaugeBuilder(DELAY_GAUGE).setUnit("s").setDescription("The age of the oldest message in the replicator backlog.").buildObserver();
        this.expiredCounter = meter.upDownCounterBuilder(EXPIRED_COUNTER).setUnit("{message}").setDescription("The total number of messages that expired for this replicator.").buildObserver();
        this.droppedCounter = meter.upDownCounterBuilder(DROPPED_COUNTER).setUnit("{message}").setDescription("The total number of messages dropped by this replicator.").buildObserver();
        this.batchCallback = meter.batchCallback(() -> pulsar.getBrokerService().getTopics().values().stream().filter(topicFuture -> topicFuture.isDone() && !topicFuture.isCompletedExceptionally()).map(CompletableFuture::join).filter(Optional::isPresent).map(Optional::get).flatMap(topic -> topic.getReplicators().values().stream()).map(AbstractReplicator.class::cast).forEach(this::recordMetricsForReplicator), (ObservableMeasurement)this.messageInCounter, new ObservableMeasurement[]{this.messageOutCounter, this.bytesInCounter, this.bytesOutCounter, this.backlogCounter, this.delayGauge, this.expiredCounter, this.droppedCounter});
    }

    @Override
    public void close() {
        this.batchCallback.close();
    }

    private void recordMetricsForReplicator(AbstractReplicator replicator) {
        Attributes attributes = replicator.getAttributes();
        ReplicatorStatsImpl stats = replicator.getStats();
        this.messageInCounter.record(stats.getMsgInCount(), attributes);
        this.messageOutCounter.record(stats.getMsgOutCount(), attributes);
        this.bytesInCounter.record(stats.getBytesInCount(), attributes);
        this.bytesOutCounter.record(stats.getBytesOutCount(), attributes);
        double delaySeconds = MetricsUtil.convertToSeconds((long)replicator.getReplicationDelayMs(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.delayGauge.record(delaySeconds, attributes);
        if (replicator instanceof PersistentReplicator) {
            PersistentReplicator persistentReplicator = (PersistentReplicator)replicator;
            this.expiredCounter.record(persistentReplicator.getMessageExpiredCount(), attributes);
            this.backlogCounter.record(persistentReplicator.getNumberOfEntriesInBacklog(), attributes);
        } else if (replicator instanceof NonPersistentReplicator) {
            NonPersistentReplicator nonPersistentReplicator = (NonPersistentReplicator)replicator;
            this.droppedCounter.record(nonPersistentReplicator.getStats().getMsgDropCount(), attributes);
        }
    }
}

