/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types.transport;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.Performative;

public final class Flow
implements Performative {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(19L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:flow:list");
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final int NEXT_INCOMING_ID = 1;
    private static final int INCOMING_WINDOW = 2;
    private static final int NEXT_OUTGOING_ID = 4;
    private static final int OUTGOING_WINDOW = 8;
    private static final int HANDLE = 16;
    private static final int DELIVERY_COUNT = 32;
    private static final int LINK_CREDIT = 64;
    private static final int AVAILABLE = 128;
    private static final int DRAIN = 256;
    private static final int ECHO = 512;
    private static final int PROPERTIES = 1024;
    private int modified = 0;
    private long nextIncomingId;
    private long incomingWindow;
    private long nextOutgoingId;
    private long outgoingWindow;
    private long handle;
    private long deliveryCount;
    private long linkCredit;
    private long available;
    private boolean drain;
    private boolean echo;
    private Map<Symbol, Object> properties;

    public boolean isEmpty() {
        return this.modified == 0;
    }

    public int getElementCount() {
        return 32 - Integer.numberOfLeadingZeros(this.modified);
    }

    public boolean hasElement(int index) {
        int value = 1 << index;
        return (this.modified & value) == value;
    }

    public boolean hasNextIncomingId() {
        return (this.modified & 1) == 1;
    }

    public boolean hasIncomingWindow() {
        return (this.modified & 2) == 2;
    }

    public boolean hasNextOutgoingId() {
        return (this.modified & 4) == 4;
    }

    public boolean hasOutgoingWindow() {
        return (this.modified & 8) == 8;
    }

    public boolean hasHandle() {
        return (this.modified & 0x10) == 16;
    }

    public boolean hasDeliveryCount() {
        return (this.modified & 0x20) == 32;
    }

    public boolean hasLinkCredit() {
        return (this.modified & 0x40) == 64;
    }

    public boolean hasAvailable() {
        return (this.modified & 0x80) == 128;
    }

    public boolean hasDrain() {
        return (this.modified & 0x100) == 256;
    }

    public boolean hasEcho() {
        return (this.modified & 0x200) == 512;
    }

    public boolean hasProperties() {
        return (this.modified & 0x400) == 1024;
    }

    public Flow reset() {
        this.modified = 0;
        this.nextIncomingId = 0L;
        this.incomingWindow = 0L;
        this.nextOutgoingId = 0L;
        this.outgoingWindow = 0L;
        this.handle = 0L;
        this.deliveryCount = 0L;
        this.linkCredit = 0L;
        this.available = 0L;
        this.drain = false;
        this.echo = false;
        this.properties = null;
        return this;
    }

    public long getNextIncomingId() {
        return this.nextIncomingId;
    }

    public Flow setNextIncomingId(int nextIncomingId) {
        this.modified |= 1;
        this.nextIncomingId = Integer.toUnsignedLong(nextIncomingId);
        return this;
    }

    public Flow setNextIncomingId(long nextIncomingId) {
        if (nextIncomingId < 0L || nextIncomingId > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Next Incoming Id value given is out of range: " + nextIncomingId);
        }
        this.modified |= 1;
        this.nextIncomingId = nextIncomingId;
        return this;
    }

    public Flow clearNextIncomingId() {
        this.modified &= 0xFFFFFFFE;
        this.nextIncomingId = 0L;
        return this;
    }

    public long getIncomingWindow() {
        return this.incomingWindow;
    }

    public Flow setIncomingWindow(int incomingWindow) {
        this.modified |= 2;
        this.incomingWindow = Integer.toUnsignedLong(incomingWindow);
        return this;
    }

    public Flow setIncomingWindow(long incomingWindow) {
        if (incomingWindow < 0L || incomingWindow > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Incoming Window value given is out of range: " + incomingWindow);
        }
        this.modified |= 2;
        this.incomingWindow = incomingWindow;
        return this;
    }

    public Flow clearIncomingWindow() {
        this.modified &= 0xFFFFFFFD;
        this.incomingWindow = 0L;
        return this;
    }

    public long getNextOutgoingId() {
        return this.nextOutgoingId;
    }

    public Flow setNextOutgoingId(int nextOutgoingId) {
        this.modified |= 4;
        this.nextOutgoingId = Integer.toUnsignedLong(nextOutgoingId);
        return this;
    }

    public Flow setNextOutgoingId(long nextOutgoingId) {
        if (nextOutgoingId < 0L || nextOutgoingId > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Next Outgoing Id value given is out of range: " + nextOutgoingId);
        }
        this.modified |= 4;
        this.nextOutgoingId = nextOutgoingId;
        return this;
    }

    public Flow clearNextOutgoingId() {
        this.modified &= 0xFFFFFFFB;
        this.nextOutgoingId = 0L;
        return this;
    }

    public long getOutgoingWindow() {
        return this.outgoingWindow;
    }

    public Flow setOutgoingWindow(int outgoingWindow) {
        this.modified |= 8;
        this.outgoingWindow = Integer.toUnsignedLong(outgoingWindow);
        return this;
    }

    public Flow setOutgoingWindow(long outgoingWindow) {
        if (outgoingWindow < 0L || outgoingWindow > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Outgoing Window value given is out of range: " + outgoingWindow);
        }
        this.modified |= 8;
        this.outgoingWindow = outgoingWindow;
        return this;
    }

    public Flow clearOutgoingWindow() {
        this.modified &= 0xFFFFFFF7;
        this.outgoingWindow = 0L;
        return this;
    }

    public long getHandle() {
        return this.handle;
    }

    public Flow setHandle(int handle) {
        this.modified |= 0x10;
        this.handle = Integer.toUnsignedLong(handle);
        return this;
    }

    public Flow setHandle(long handle) {
        if (handle < 0L || handle > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Handle value given is out of range: " + handle);
        }
        this.modified |= 0x10;
        this.handle = handle;
        return this;
    }

    public Flow clearHandle() {
        this.modified &= 0xFFFFFFEF;
        this.handle = 0L;
        return this;
    }

    public long getDeliveryCount() {
        return this.deliveryCount;
    }

    public Flow setDeliveryCount(int deliveryCount) {
        this.modified |= 0x20;
        this.deliveryCount = Integer.toUnsignedLong(deliveryCount);
        return this;
    }

    public Flow setDeliveryCount(long deliveryCount) {
        if (deliveryCount < 0L || deliveryCount > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Delivery Count value given is out of range: " + deliveryCount);
        }
        this.modified |= 0x20;
        this.deliveryCount = deliveryCount;
        return this;
    }

    public Flow clearDeliveryCount() {
        this.modified &= 0xFFFFFFDF;
        this.deliveryCount = 0L;
        return this;
    }

    public long getLinkCredit() {
        return this.linkCredit;
    }

    public Flow setLinkCredit(int linkCredit) {
        this.modified |= 0x40;
        this.linkCredit = Integer.toUnsignedLong(linkCredit);
        return this;
    }

    public Flow setLinkCredit(long linkCredit) {
        if (linkCredit < 0L || linkCredit > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Link Credit value given is out of range: " + linkCredit);
        }
        this.modified |= 0x40;
        this.linkCredit = linkCredit;
        return this;
    }

    public Flow clearLinkCredit() {
        this.modified &= 0xFFFFFFBF;
        this.linkCredit = 0L;
        return this;
    }

    public long getAvailable() {
        return this.available;
    }

    public Flow setAvailable(int available) {
        this.modified |= 0x80;
        this.available = Integer.toUnsignedLong(available);
        return this;
    }

    public Flow setAvailable(long available) {
        if (available < 0L || available > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Available value given is out of range: " + available);
        }
        this.modified |= 0x80;
        this.available = available;
        return this;
    }

    public Flow clearAvailable() {
        this.modified &= 0xFFFFFF7F;
        this.available = 0L;
        return this;
    }

    public boolean getDrain() {
        return this.drain;
    }

    public Flow setDrain(boolean drain) {
        this.modified |= 0x100;
        this.drain = drain;
        return this;
    }

    public Flow clearDrain() {
        this.modified &= 0xFFFFFEFF;
        this.drain = false;
        return this;
    }

    public boolean getEcho() {
        return this.echo;
    }

    public Flow setEcho(boolean echo) {
        this.modified |= 0x200;
        this.echo = echo;
        return this;
    }

    public Flow clearEcho() {
        this.modified &= 0xFFFFFDFF;
        this.echo = false;
        return this;
    }

    public Map<Symbol, Object> getProperties() {
        return this.properties;
    }

    public Flow setProperties(Map<Symbol, Object> properties) {
        this.modified = properties != null ? (this.modified |= 0x400) : (this.modified &= 0xFFFFFBFF);
        this.properties = properties;
        return this;
    }

    public Flow clearProperties() {
        this.modified &= 0xFFFFFBFF;
        this.properties = null;
        return this;
    }

    @Override
    public Flow copy() {
        Flow copy = new Flow();
        copy.nextIncomingId = this.nextIncomingId;
        copy.incomingWindow = this.incomingWindow;
        copy.nextOutgoingId = this.nextOutgoingId;
        copy.outgoingWindow = this.outgoingWindow;
        copy.handle = this.handle;
        copy.deliveryCount = this.deliveryCount;
        copy.linkCredit = this.linkCredit;
        copy.available = this.available;
        copy.drain = this.drain;
        copy.echo = this.echo;
        if (this.properties != null) {
            copy.properties = new LinkedHashMap<Symbol, Object>(this.properties);
        }
        copy.modified = this.modified;
        return copy;
    }

    @Override
    public Performative.PerformativeType getPerformativeType() {
        return Performative.PerformativeType.FLOW;
    }

    @Override
    public <E> void invoke(Performative.PerformativeHandler<E> handler, ProtonBuffer payload, int channel, E context) {
        handler.handleFlow(this, payload, channel, context);
    }

    public String toString() {
        return "Flow{nextIncomingId=" + (Serializable)(this.hasNextIncomingId() ? Long.valueOf(this.nextIncomingId) : "null") + ", incomingWindow=" + (Serializable)(this.hasIncomingWindow() ? Long.valueOf(this.incomingWindow) : "null") + ", nextOutgoingId=" + (Serializable)(this.hasNextOutgoingId() ? Long.valueOf(this.nextOutgoingId) : "null") + ", outgoingWindow=" + (Serializable)(this.hasOutgoingWindow() ? Long.valueOf(this.outgoingWindow) : "null") + ", handle=" + (Serializable)(this.hasHandle() ? Long.valueOf(this.handle) : "null") + ", deliveryCount=" + (Serializable)(this.hasDeliveryCount() ? Long.valueOf(this.deliveryCount) : "null") + ", linkCredit=" + (Serializable)(this.hasLinkCredit() ? Long.valueOf(this.linkCredit) : "null") + ", available=" + (Serializable)(this.hasAvailable() ? Long.valueOf(this.available) : "null") + ", drain=" + (Serializable)(this.hasDrain() ? Boolean.valueOf(this.drain) : "null") + ", echo=" + (Serializable)(this.hasEcho() ? Boolean.valueOf(this.echo) : "null") + ", properties=" + this.properties + "}";
    }
}

