/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.eql;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.NodesResponseHeader;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class EqlStatsResponse {
    private final NodesResponseHeader header;
    private final String clusterName;
    private final List<Node> nodes;
    private static final ConstructingObjectParser<EqlStatsResponse, Void> PARSER = new ConstructingObjectParser("eql/stats_response", true, args -> {
        int i = 0;
        NodesResponseHeader header = (NodesResponseHeader)args[i++];
        String clusterName = (String)args[i++];
        List nodes = (List)args[i];
        return new EqlStatsResponse(header, clusterName, nodes);
    });

    public EqlStatsResponse(NodesResponseHeader header, String clusterName, List<Node> nodes) {
        this.header = header;
        this.clusterName = clusterName;
        this.nodes = nodes;
    }

    public static EqlStatsResponse fromXContent(XContentParser parser) throws IOException {
        return (EqlStatsResponse)PARSER.parse(parser, null);
    }

    public NodesResponseHeader getHeader() {
        return this.header;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqlStatsResponse that = (EqlStatsResponse)o;
        return Objects.equals(this.nodes, that.nodes) && Objects.equals(this.header, that.header) && Objects.equals(this.clusterName, that.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.header, this.clusterName);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), NodesResponseHeader::fromXContent, new ParseField("_nodes", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("cluster_name", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> (Node)Node.PARSER.apply(p, null), new ParseField("stats", new String[0]));
    }

    public static class Node {
        public static final ConstructingObjectParser<Node, Void> PARSER = new ConstructingObjectParser("eql/stats_response_node", true, (args, c) -> new Node((Map)args[0]));
        private Map<String, Object> stats;

        public Node(Map<String, Object> stats) {
            this.stats = stats;
        }

        public Map<String, Object> getStats() {
            return this.stats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.stats, node.stats);
        }

        public int hashCode() {
            return Objects.hash(this.stats);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("stats", new String[0]));
        }
    }
}

