/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kylin.authorizer;

import java.util.List;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.security.ExternalAclProvider;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.acls.model.Permission;

public class RangerKylinAuthorizer
extends ExternalAclProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerKylinAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "kylin";
    private static final String RANGER_KYLIN_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.kylin.authorizer.RangerKylinAuthorizer";
    private ExternalAclProvider externalAclProvider = null;
    private RangerPluginClassLoader rangerPluginClassLoader = null;

    public RangerKylinAuthorizer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKylinAuthorizer.RangerKylinAuthorizer()");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKylinAuthorizer.RangerKylinAuthorizer()");
        }
    }

    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKylinAuthorizer.init()");
        }
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, ((Object)((Object)this)).getClass());
            Class<?> cls = Class.forName(RANGER_KYLIN_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.externalAclProvider = (ExternalAclProvider)cls.newInstance();
            this.externalAclProvider.init();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerKylinPlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKylinAuthorizer.init()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPermission(String user, List<String> groups, String entityType, String entityUuid, Permission permission) {
        boolean ret = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKylinAuthorizer.checkPermission()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.externalAclProvider.checkPermission(user, groups, entityType, entityUuid, permission);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKylinAuthorizer.checkPermission()");
        }
        return ret;
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }

    public List<Pair<String, AclPermission>> getAcl(String entityType, String entityUuid) {
        return null;
    }
}

