/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.redis.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.redis.RedisLinkedServerCreateParameters;
import com.microsoft.azure.management.redis.implementation.PageImpl;
import com.microsoft.azure.management.redis.implementation.RedisLinkedServerWithPropertiesInner;
import com.microsoft.azure.management.redis.implementation.RedisManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class LinkedServersInner {
    private LinkedServersService service;
    private RedisManagementClientImpl client;

    public LinkedServersInner(Retrofit retrofit, RedisManagementClientImpl client) {
        this.service = (LinkedServersService)retrofit.create(LinkedServersService.class);
        this.client = client;
    }

    public RedisLinkedServerWithPropertiesInner create(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        return (RedisLinkedServerWithPropertiesInner)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<RedisLinkedServerWithPropertiesInner> createAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters, ServiceCallback<RedisLinkedServerWithPropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters), serviceCallback);
    }

    public Observable<RedisLinkedServerWithPropertiesInner> createAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters).map((Func1)new Func1<ServiceResponse<RedisLinkedServerWithPropertiesInner>, RedisLinkedServerWithPropertiesInner>(){

            public RedisLinkedServerWithPropertiesInner call(ServiceResponse<RedisLinkedServerWithPropertiesInner> response) {
                return (RedisLinkedServerWithPropertiesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>> createWithServiceResponseAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (linkedServerName == null) {
            throw new IllegalArgumentException("Parameter linkedServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, name, linkedServerName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RedisLinkedServerWithPropertiesInner>(){}.getType());
    }

    public RedisLinkedServerWithPropertiesInner beginCreate(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        return (RedisLinkedServerWithPropertiesInner)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<RedisLinkedServerWithPropertiesInner> beginCreateAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters, ServiceCallback<RedisLinkedServerWithPropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters), serviceCallback);
    }

    public Observable<RedisLinkedServerWithPropertiesInner> beginCreateAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, name, linkedServerName, parameters).map((Func1)new Func1<ServiceResponse<RedisLinkedServerWithPropertiesInner>, RedisLinkedServerWithPropertiesInner>(){

            public RedisLinkedServerWithPropertiesInner call(ServiceResponse<RedisLinkedServerWithPropertiesInner> response) {
                return (RedisLinkedServerWithPropertiesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String name, String linkedServerName, RedisLinkedServerCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (linkedServerName == null) {
            throw new IllegalArgumentException("Parameter linkedServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, name, linkedServerName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>>>(){

            public Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LinkedServersInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisLinkedServerWithPropertiesInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisLinkedServerWithPropertiesInner>(){}.getType()).register(201, new TypeToken<RedisLinkedServerWithPropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String name, String linkedServerName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, name, linkedServerName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String name, String linkedServerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, name, linkedServerName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String name, String linkedServerName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, name, linkedServerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String name, String linkedServerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (linkedServerName == null) {
            throw new IllegalArgumentException("Parameter linkedServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, name, linkedServerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LinkedServersInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RedisLinkedServerWithPropertiesInner get(String resourceGroupName, String name, String linkedServerName) {
        return (RedisLinkedServerWithPropertiesInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, name, linkedServerName).toBlocking().single()).body();
    }

    public ServiceFuture<RedisLinkedServerWithPropertiesInner> getAsync(String resourceGroupName, String name, String linkedServerName, ServiceCallback<RedisLinkedServerWithPropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, name, linkedServerName), serviceCallback);
    }

    public Observable<RedisLinkedServerWithPropertiesInner> getAsync(String resourceGroupName, String name, String linkedServerName) {
        return this.getWithServiceResponseAsync(resourceGroupName, name, linkedServerName).map((Func1)new Func1<ServiceResponse<RedisLinkedServerWithPropertiesInner>, RedisLinkedServerWithPropertiesInner>(){

            public RedisLinkedServerWithPropertiesInner call(ServiceResponse<RedisLinkedServerWithPropertiesInner> response) {
                return (RedisLinkedServerWithPropertiesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>> getWithServiceResponseAsync(String resourceGroupName, String name, String linkedServerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (linkedServerName == null) {
            throw new IllegalArgumentException("Parameter linkedServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, name, linkedServerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>>>(){

            public Observable<ServiceResponse<RedisLinkedServerWithPropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LinkedServersInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RedisLinkedServerWithPropertiesInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RedisLinkedServerWithPropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RedisLinkedServerWithPropertiesInner> list(String resourceGroupName, String name) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<RedisLinkedServerWithPropertiesInner>((Page)response.body()){

            public Page<RedisLinkedServerWithPropertiesInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LinkedServersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RedisLinkedServerWithPropertiesInner>> listAsync(String resourceGroupName, String name, ListOperationCallback<RedisLinkedServerWithPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, name), (Func1)new Func1<String, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(String nextPageLink) {
                return LinkedServersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RedisLinkedServerWithPropertiesInner>> listAsync(String resourceGroupName, String name) {
        return this.listWithServiceResponseAsync(resourceGroupName, name).map((Func1)new Func1<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>, Page<RedisLinkedServerWithPropertiesInner>>(){

            public Page<RedisLinkedServerWithPropertiesInner> call(ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> listWithServiceResponseAsync(String resourceGroupName, String name) {
        return this.listSinglePageAsync(resourceGroupName, name).concatMap((Func1)new Func1<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LinkedServersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> listSinglePageAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LinkedServersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RedisLinkedServerWithPropertiesInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RedisLinkedServerWithPropertiesInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RedisLinkedServerWithPropertiesInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RedisLinkedServerWithPropertiesInner>((Page)response.body()){

            public Page<RedisLinkedServerWithPropertiesInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LinkedServersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RedisLinkedServerWithPropertiesInner>> listNextAsync(String nextPageLink, ServiceFuture<List<RedisLinkedServerWithPropertiesInner>> serviceFuture, ListOperationCallback<RedisLinkedServerWithPropertiesInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(String nextPageLink) {
                return LinkedServersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RedisLinkedServerWithPropertiesInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>, Page<RedisLinkedServerWithPropertiesInner>>(){

            public Page<RedisLinkedServerWithPropertiesInner> call(ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LinkedServersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>>>(){

            public Observable<ServiceResponse<Page<RedisLinkedServerWithPropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LinkedServersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RedisLinkedServerWithPropertiesInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RedisLinkedServerWithPropertiesInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LinkedServersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="linkedServerName") String var3, @Path(value="subscriptionId") String var4, @Body RedisLinkedServerCreateParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="linkedServerName") String var3, @Path(value="subscriptionId") String var4, @Body RedisLinkedServerCreateParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="linkedServerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers/{linkedServerName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="linkedServerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/Redis/{name}/linkedServers")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.redis.LinkedServers listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

