/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.outlierdetection;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class AucRocMetric
implements EvaluationMetric {
    public static final String NAME = "auc_roc";
    public static final ParseField INCLUDE_CURVE = new ParseField("include_curve", new String[0]);
    public static final ConstructingObjectParser<AucRocMetric, Void> PARSER = new ConstructingObjectParser("auc_roc", true, args -> new AucRocMetric((Boolean)args[0]));
    private final Boolean includeCurve;

    public static AucRocMetric fromXContent(XContentParser parser) {
        return (AucRocMetric)PARSER.apply(parser, null);
    }

    public static AucRocMetric withCurve() {
        return new AucRocMetric(true);
    }

    public AucRocMetric(Boolean includeCurve) {
        this.includeCurve = includeCurve;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.includeCurve != null) {
            builder.field(INCLUDE_CURVE.getPreferredName(), this.includeCurve);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AucRocMetric that = (AucRocMetric)o;
        return Objects.equals(this.includeCurve, that.includeCurve);
    }

    public int hashCode() {
        return Objects.hash(this.includeCurve);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), INCLUDE_CURVE);
    }
}

