/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.keyvault.SecretIdentifier;
import com.microsoft.azure.keyvault.models.Attributes;
import com.microsoft.azure.keyvault.models.SecretAttributes;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.azure.keyvault.models.SecretItem;
import com.microsoft.azure.keyvault.requests.SetSecretRequest;
import com.microsoft.azure.keyvault.requests.UpdateSecretRequest;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.keyvault.Secret;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultFutures;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.rest.ServiceFuture;
import java.util.Map;
import java.util.concurrent.Future;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;

@LangDefinition
class SecretImpl
extends CreatableUpdatableImpl<Secret, SecretBundle, SecretImpl>
implements Secret,
Secret.Definition,
Secret.Update {
    private final Vault vault;
    private SetSecretRequest.Builder setSecretRequest;
    private UpdateSecretRequest.Builder updateSecretRequest;

    SecretImpl(String name, SecretBundle innerObject, Vault vault) {
        super(name, (Object)innerObject);
        this.vault = vault;
        this.updateSecretRequest = new UpdateSecretRequest.Builder(vault.vaultUri(), name);
    }

    public String id() {
        return ((SecretBundle)this.inner()).id();
    }

    @Override
    public String value() {
        return ((SecretBundle)this.inner()).value();
    }

    @Override
    public SecretAttributes attributes() {
        return ((SecretBundle)this.inner()).attributes();
    }

    @Override
    public Map<String, String> tags() {
        return ((SecretBundle)this.inner()).tags();
    }

    @Override
    public String contentType() {
        return ((SecretBundle)this.inner()).contentType();
    }

    @Override
    public String kid() {
        return ((SecretBundle)this.inner()).kid();
    }

    @Override
    public boolean managed() {
        return Utils.toPrimitiveBoolean((Boolean)((SecretBundle)this.inner()).managed());
    }

    @Override
    public PagedList<Secret> listVersions() {
        return new PagedListConverter<SecretItem, Secret>(){

            public Observable<Secret> typeConvertAsync(final SecretItem secretItem) {
                return new KeyVaultFutures.ServiceFutureConverter<SecretBundle, Secret>(){

                    @Override
                    protected ServiceFuture<SecretBundle> callAsync() {
                        return SecretImpl.this.vault.client().getSecretAsync(secretItem.identifier().identifier(), null);
                    }

                    @Override
                    protected Secret wrapModel(SecretBundle secretBundle) {
                        return new SecretImpl(secretBundle.secretIdentifier().name(), secretBundle, SecretImpl.this.vault);
                    }
                }.toObservable();
            }
        }.convert(this.vault.client().listSecretVersions(this.vault.vaultUri(), this.name()));
    }

    @Override
    public Observable<Secret> listVersionsAsync() {
        return new KeyVaultFutures.ListCallbackObserver<SecretItem, SecretIdentifier>(){

            @Override
            protected void list(ListOperationCallback<SecretItem> callback) {
                SecretImpl.this.vault.client().listSecretVersionsAsync(SecretImpl.this.vault.vaultUri(), SecretImpl.this.name(), callback);
            }

            @Override
            protected Observable<SecretIdentifier> typeConvertAsync(SecretItem o) {
                return Observable.just((Object)o.identifier());
            }
        }.toObservable().flatMap((Func1)new Func1<SecretIdentifier, Observable<Secret>>(){

            public Observable<Secret> call(final SecretIdentifier secretIdentifier) {
                return new KeyVaultFutures.ServiceFutureConverter<SecretBundle, Secret>(){

                    @Override
                    protected ServiceFuture<SecretBundle> callAsync() {
                        return SecretImpl.this.vault.client().getSecretAsync(secretIdentifier.identifier(), null);
                    }

                    @Override
                    protected Secret wrapModel(SecretBundle secretBundle) {
                        return new SecretImpl(secretIdentifier.name(), secretBundle, SecretImpl.this.vault);
                    }
                }.toObservable();
            }
        });
    }

    protected Observable<SecretBundle> getInnerAsync() {
        return Observable.from((Future)this.vault.client().getSecretAsync(this.id(), null));
    }

    @Override
    public SecretImpl withTags(Map<String, String> tags) {
        this.setSecretRequest.withTags(tags);
        this.updateSecretRequest.withTags(tags);
        return this;
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Observable<Secret> createResourceAsync() {
        return Observable.from((Future)this.vault.client().setSecretAsync(this.setSecretRequest.build(), null)).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).doOnCompleted(new Action0(){

            public void call() {
                SecretImpl.this.setSecretRequest = null;
                SecretImpl.this.updateSecretRequest = new UpdateSecretRequest.Builder(SecretImpl.this.vault.vaultUri(), SecretImpl.this.name());
            }
        });
    }

    public Observable<Secret> updateResourceAsync() {
        Observable<Secret> set = Observable.just((Object)this);
        if (this.setSecretRequest != null) {
            set = this.createResourceAsync();
        }
        return set.flatMap((Func1)new Func1<Secret, Observable<SecretBundle>>(){

            public Observable<SecretBundle> call(Secret secret) {
                return Observable.from((Future)SecretImpl.this.vault.client().updateSecretAsync(SecretImpl.this.updateSecretRequest.build(), null));
            }
        }).flatMap((Func1)new Func1<SecretBundle, Observable<Secret>>(){

            public Observable<Secret> call(SecretBundle secretBundle) {
                return SecretImpl.this.refreshAsync();
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                SecretImpl.this.setSecretRequest = null;
                SecretImpl.this.updateSecretRequest = new UpdateSecretRequest.Builder(SecretImpl.this.vault.vaultUri(), SecretImpl.this.name());
            }
        });
    }

    @Override
    public SecretImpl withAttributes(Attributes attributes) {
        this.setSecretRequest.withAttributes(attributes);
        this.updateSecretRequest.withAttributes(attributes);
        return this;
    }

    @Override
    public SecretImpl withVersion(String version) {
        this.updateSecretRequest.withVersion(version);
        return this;
    }

    @Override
    public SecretImpl withValue(String value) {
        this.setSecretRequest = new SetSecretRequest.Builder(this.vault.vaultUri(), this.name(), value);
        return this;
    }

    @Override
    public SecretImpl withContentType(String contentType) {
        this.setSecretRequest.withContentType(contentType);
        this.updateSecretRequest.withContentType(contentType);
        return this;
    }
}

