/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.management.appservice.implementation.PageImpl;
import com.microsoft.azure.management.appservice.implementation.ResourceHealthMetadataInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ResourceHealthMetadatasInner
implements InnerSupportsListing<ResourceHealthMetadataInner> {
    private ResourceHealthMetadatasService service;
    private WebSiteManagementClientImpl client;

    public ResourceHealthMetadatasInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = (ResourceHealthMetadatasService)retrofit.create(ResourceHealthMetadatasService.class);
        this.client = client;
    }

    public PagedList<ResourceHealthMetadataInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>((Page)response.body()){

            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceHealthMetadatasInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceHealthMetadataInner>> listAsync(ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                return ResourceHealthMetadatasInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceHealthMetadataInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>(){

            public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceHealthMetadatasInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceHealthMetadatasInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<ResourceHealthMetadataInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>((Page)response.body()){

            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceHealthMetadatasInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceHealthMetadataInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                return ResourceHealthMetadatasInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceHealthMetadataInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>(){

            public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceHealthMetadatasInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceHealthMetadatasInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<ResourceHealthMetadataInner> listBySite(String resourceGroupName, String name) {
        ServiceResponse response = (ServiceResponse)this.listBySiteSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>((Page)response.body()){

            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceHealthMetadatasInner.this.listBySiteNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceHealthMetadataInner>> listBySiteAsync(String resourceGroupName, String name, ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBySiteSinglePageAsync(resourceGroupName, name), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                return ResourceHealthMetadatasInner.this.listBySiteNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceHealthMetadataInner>> listBySiteAsync(String resourceGroupName, String name) {
        return this.listBySiteWithServiceResponseAsync(resourceGroupName, name).map((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>(){

            public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteWithServiceResponseAsync(String resourceGroupName, String name) {
        return this.listBySiteSinglePageAsync(resourceGroupName, name).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceHealthMetadatasInner.this.listBySiteNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteSinglePageAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listBySite(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceHealthMetadatasInner.this.listBySiteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listBySiteDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public ResourceHealthMetadataInner getBySite(String resourceGroupName, String name) {
        return (ResourceHealthMetadataInner)((Object)((ServiceResponse)this.getBySiteWithServiceResponseAsync(resourceGroupName, name).toBlocking().single()).body());
    }

    public ServiceFuture<ResourceHealthMetadataInner> getBySiteAsync(String resourceGroupName, String name, ServiceCallback<ResourceHealthMetadataInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getBySiteWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    public Observable<ResourceHealthMetadataInner> getBySiteAsync(String resourceGroupName, String name) {
        return this.getBySiteWithServiceResponseAsync(resourceGroupName, name).map((Func1)new Func1<ServiceResponse<ResourceHealthMetadataInner>, ResourceHealthMetadataInner>(){

            public ResourceHealthMetadataInner call(ServiceResponse<ResourceHealthMetadataInner> response) {
                return (ResourceHealthMetadataInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ResourceHealthMetadataInner>> getBySiteWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getBySite(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceHealthMetadataInner>>>(){

            public Observable<ServiceResponse<ResourceHealthMetadataInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceHealthMetadatasInner.this.getBySiteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceHealthMetadataInner> getBySiteDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceHealthMetadataInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<ResourceHealthMetadataInner> listBySiteSlot(String resourceGroupName, String name, String slot) {
        ServiceResponse response = (ServiceResponse)this.listBySiteSlotSinglePageAsync(resourceGroupName, name, slot).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>((Page)response.body()){

            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceHealthMetadatasInner.this.listBySiteSlotNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceHealthMetadataInner>> listBySiteSlotAsync(String resourceGroupName, String name, String slot, ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBySiteSlotSinglePageAsync(resourceGroupName, name, slot), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                return ResourceHealthMetadatasInner.this.listBySiteSlotNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceHealthMetadataInner>> listBySiteSlotAsync(String resourceGroupName, String name, String slot) {
        return this.listBySiteSlotWithServiceResponseAsync(resourceGroupName, name, slot).map((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>(){

            public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteSlotWithServiceResponseAsync(String resourceGroupName, String name, String slot) {
        return this.listBySiteSlotSinglePageAsync(resourceGroupName, name, slot).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceHealthMetadatasInner.this.listBySiteSlotNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteSlotSinglePageAsync(String resourceGroupName, String name, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listBySiteSlot(resourceGroupName, name, slot, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceHealthMetadatasInner.this.listBySiteSlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listBySiteSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public ResourceHealthMetadataInner getBySiteSlot(String resourceGroupName, String name, String slot) {
        return (ResourceHealthMetadataInner)((Object)((ServiceResponse)this.getBySiteSlotWithServiceResponseAsync(resourceGroupName, name, slot).toBlocking().single()).body());
    }

    public ServiceFuture<ResourceHealthMetadataInner> getBySiteSlotAsync(String resourceGroupName, String name, String slot, ServiceCallback<ResourceHealthMetadataInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getBySiteSlotWithServiceResponseAsync(resourceGroupName, name, slot), serviceCallback);
    }

    public Observable<ResourceHealthMetadataInner> getBySiteSlotAsync(String resourceGroupName, String name, String slot) {
        return this.getBySiteSlotWithServiceResponseAsync(resourceGroupName, name, slot).map((Func1)new Func1<ServiceResponse<ResourceHealthMetadataInner>, ResourceHealthMetadataInner>(){

            public ResourceHealthMetadataInner call(ServiceResponse<ResourceHealthMetadataInner> response) {
                return (ResourceHealthMetadataInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ResourceHealthMetadataInner>> getBySiteSlotWithServiceResponseAsync(String resourceGroupName, String name, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getBySiteSlot(resourceGroupName, name, slot, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceHealthMetadataInner>>>(){

            public Observable<ServiceResponse<ResourceHealthMetadataInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceHealthMetadatasInner.this.getBySiteSlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceHealthMetadataInner> getBySiteSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceHealthMetadataInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<ResourceHealthMetadataInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>((Page)response.body()){

            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceHealthMetadatasInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceHealthMetadataInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ResourceHealthMetadataInner>> serviceFuture, ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                return ResourceHealthMetadatasInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceHealthMetadataInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>(){

            public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceHealthMetadatasInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceHealthMetadatasInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<ResourceHealthMetadataInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>((Page)response.body()){

            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceHealthMetadatasInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceHealthMetadataInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ResourceHealthMetadataInner>> serviceFuture, ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                return ResourceHealthMetadatasInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceHealthMetadataInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>(){

            public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceHealthMetadatasInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceHealthMetadatasInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<ResourceHealthMetadataInner> listBySiteNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listBySiteNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>((Page)response.body()){

            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceHealthMetadatasInner.this.listBySiteNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceHealthMetadataInner>> listBySiteNextAsync(String nextPageLink, ServiceFuture<List<ResourceHealthMetadataInner>> serviceFuture, ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBySiteNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                return ResourceHealthMetadatasInner.this.listBySiteNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceHealthMetadataInner>> listBySiteNextAsync(String nextPageLink) {
        return this.listBySiteNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>(){

            public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteNextWithServiceResponseAsync(String nextPageLink) {
        return this.listBySiteNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceHealthMetadatasInner.this.listBySiteNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listBySiteNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceHealthMetadatasInner.this.listBySiteNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listBySiteNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<ResourceHealthMetadataInner> listBySiteSlotNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listBySiteSlotNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>((Page)response.body()){

            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceHealthMetadatasInner.this.listBySiteSlotNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceHealthMetadataInner>> listBySiteSlotNextAsync(String nextPageLink, ServiceFuture<List<ResourceHealthMetadataInner>> serviceFuture, ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBySiteSlotNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                return ResourceHealthMetadatasInner.this.listBySiteSlotNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceHealthMetadataInner>> listBySiteSlotNextAsync(String nextPageLink) {
        return this.listBySiteSlotNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>(){

            public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteSlotNextWithServiceResponseAsync(String nextPageLink) {
        return this.listBySiteSlotNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceHealthMetadatasInner.this.listBySiteSlotNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteSlotNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listBySiteSlotNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceHealthMetadatasInner.this.listBySiteSlotNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listBySiteSlotNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    static interface ResourceHealthMetadatasService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/resourceHealthMetadata")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/resourceHealthMetadata")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listBySite"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resourceHealthMetadata")
        public Observable<Response<ResponseBody>> listBySite(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas getBySite"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resourceHealthMetadata/default")
        public Observable<Response<ResponseBody>> getBySite(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listBySiteSlot"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resourceHealthMetadata")
        public Observable<Response<ResponseBody>> listBySiteSlot(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="slot") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas getBySiteSlot"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resourceHealthMetadata/default")
        public Observable<Response<ResponseBody>> getBySiteSlot(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="slot") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listBySiteNext"})
        @GET
        public Observable<Response<ResponseBody>> listBySiteNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listBySiteSlotNext"})
        @GET
        public Observable<Response<ResponseBody>> listBySiteSlotNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

