/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.collect.Lists;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.ComputeResourceType;
import com.microsoft.azure.management.compute.ComputeSku;
import com.microsoft.azure.management.compute.ComputeSkus;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.ComputeSkuImpl;
import com.microsoft.azure.management.compute.implementation.ResourceSkuInner;
import com.microsoft.azure.management.compute.implementation.ResourceSkusInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.rest.RestException;
import java.io.IOException;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
final class ComputeSkusImpl
extends ReadableWrappersImpl<ComputeSku, ComputeSkuImpl, ResourceSkuInner>
implements ComputeSkus {
    private final ComputeManager manager;

    ComputeSkusImpl(ComputeManager computeManager) {
        this.manager = computeManager;
    }

    protected ComputeSkuImpl wrapModel(ResourceSkuInner inner) {
        return new ComputeSkuImpl(inner);
    }

    public PagedList<ComputeSku> list() {
        return this.wrapList(this.inner().list());
    }

    public Observable<ComputeSku> listAsync() {
        return this.wrapPageAsync(this.inner().listAsync());
    }

    public PagedList<ComputeSku> listByRegion(String regionName) {
        return this.listByRegion(Region.fromName((String)regionName));
    }

    public PagedList<ComputeSku> listByRegion(Region region) {
        return ComputeSkusImpl.toPagedList(this.listByRegionAsync(region));
    }

    public Observable<ComputeSku> listByRegionAsync(String regionName) {
        return this.listByRegionAsync(Region.fromName((String)regionName));
    }

    public Observable<ComputeSku> listByRegionAsync(final Region region) {
        return this.listAsync().filter((Func1)new Func1<ComputeSku, Boolean>(){

            public Boolean call(ComputeSku computeSku) {
                return computeSku.regions() != null && computeSku.regions().contains(region);
            }
        });
    }

    public ResourceSkusInner inner() {
        return ((ComputeManagementClientImpl)((Object)this.manager.inner())).resourceSkus();
    }

    public ComputeManager manager() {
        return this.manager;
    }

    @Override
    public PagedList<ComputeSku> listByResourceType(ComputeResourceType resourceType) {
        return ComputeSkusImpl.toPagedList(this.listByResourceTypeAsync(resourceType));
    }

    @Override
    public Observable<ComputeSku> listByResourceTypeAsync(final ComputeResourceType resourceType) {
        return this.listAsync().filter((Func1)new Func1<ComputeSku, Boolean>(){

            public Boolean call(ComputeSku computeSku) {
                return computeSku.resourceType() != null && computeSku.resourceType().equals((Object)resourceType);
            }
        });
    }

    @Override
    public PagedList<ComputeSku> listbyRegionAndResourceType(Region region, ComputeResourceType resourceType) {
        return ComputeSkusImpl.toPagedList(this.listbyRegionAndResourceTypeAsync(region, resourceType));
    }

    @Override
    public Observable<ComputeSku> listbyRegionAndResourceTypeAsync(final Region region, final ComputeResourceType resourceType) {
        return this.listAsync().filter((Func1)new Func1<ComputeSku, Boolean>(){

            public Boolean call(ComputeSku computeSku) {
                return computeSku.resourceType() != null && computeSku.resourceType().equals((Object)resourceType) && computeSku.regions() != null && computeSku.regions().contains(region);
            }
        });
    }

    private static <T> PagedList<T> toPagedList(final Observable<T> skuObservable) {
        Page singlePage = new Page<T>(){

            public List<T> items() {
                return Lists.newArrayList((Iterable)skuObservable.toBlocking().toIterable());
            }

            public String nextPageLink() {
                return null;
            }
        };
        return new PagedList<T>(singlePage){

            public Page<T> nextPage(String s) throws RestException, IOException {
                return null;
            }
        };
    }
}

