/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptEdits {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptEdits.class);
    private static final String DOUBLE_BRACKET_START = "[[";
    private static final String DOUBLE_BRACKET_END = "]]";
    private static final String DOUBLE_BRACKET_REGEX = "\\[\\[([}{\\$\"a-zA-Z0-9_.\\[\\]]+)(\\,['\\\"](.+?)['\\\"])*\\]\\]";
    private static final Pattern DOUBLE_BRACKET_PATTERN = Pattern.compile("\\[\\[([}{\\$\"a-zA-Z0-9_.\\[\\]]+)(\\,['\\\"](.+?)['\\\"])*\\]\\]");

    public static boolean hasDoubleBrackets(String str) {
        return StringUtils.contains((String)str, (String)DOUBLE_BRACKET_START) && StringUtils.contains((String)str, (String)DOUBLE_BRACKET_END);
    }

    public static String replaceDoubleBrackets(String str) {
        String ret = str;
        Matcher m = DOUBLE_BRACKET_PATTERN.matcher(str);
        while (m.find()) {
            String tokenToReplace = m.group(0);
            String expr = m.group(1);
            String delimiterSpec = m.group(2);
            String delimiter = m.group(3);
            if (delimiter == null) {
                delimiter = ",";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("replaceDoubleBrackets({}): tokenToReplace={} expr={} delimiterSpec={} delimiter={}", new Object[]{str, tokenToReplace, expr, delimiterSpec, delimiter});
            }
            ret = ret.replace(tokenToReplace, expr + ".split(\"" + delimiter + "\")");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== replaceDoubleBrackets({}): ret={}", (Object)str, (Object)ret);
        }
        return ret;
    }
}

