/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.AddressSpace;
import com.microsoft.azure.management.network.DdosProtectionPlan;
import com.microsoft.azure.management.network.DhcpOptions;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.NetworkPeerings;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.IPAddressAvailabilityResultInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkPeeringsImpl;
import com.microsoft.azure.management.network.implementation.SubnetImpl;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworksInner;
import com.microsoft.azure.management.network.model.GroupableParentResourceWithTagsImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class NetworkImpl
extends GroupableParentResourceWithTagsImpl<Network, VirtualNetworkInner, NetworkImpl, NetworkManager>
implements Network,
Network.Definition,
Network.Update {
    private Map<String, Subnet> subnets;
    private NetworkPeeringsImpl peerings;
    private Creatable<DdosProtectionPlan> ddosProtectionPlanCreatable;

    NetworkImpl(String name, VirtualNetworkInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    protected void initializeChildrenFromInner() {
        this.subnets = new TreeMap<String, Subnet>();
        List<SubnetInner> inners = ((VirtualNetworkInner)((Object)this.inner())).subnets();
        if (inners != null) {
            for (SubnetInner inner : inners) {
                SubnetImpl subnet = new SubnetImpl(inner, this);
                this.subnets.put(inner.name(), subnet);
            }
        }
        this.peerings = new NetworkPeeringsImpl(this);
    }

    public Observable<Network> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<Network, Network>(){

            public Network call(Network network) {
                NetworkImpl impl = (NetworkImpl)network;
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    protected Observable<VirtualNetworkInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).virtualNetworks().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    protected Observable<VirtualNetworkInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).virtualNetworks().updateTagsAsync(this.resourceGroupName(), this.name(), ((VirtualNetworkInner)((Object)this.inner())).getTags());
    }

    @Override
    public boolean isPrivateIPAddressAvailable(String ipAddress) {
        IPAddressAvailabilityResultInner result = this.checkIPAvailability(ipAddress);
        return result != null ? result.available() : false;
    }

    @Override
    public boolean isPrivateIPAddressInNetwork(String ipAddress) {
        IPAddressAvailabilityResultInner result = this.checkIPAvailability(ipAddress);
        return result != null;
    }

    private IPAddressAvailabilityResultInner checkIPAvailability(String ipAddress) {
        IPAddressAvailabilityResultInner result;
        block3: {
            if (ipAddress == null) {
                return null;
            }
            result = null;
            try {
                result = ((VirtualNetworksInner)((NetworkManager)this.manager()).networks().inner()).checkIPAddressAvailability(this.resourceGroupName(), this.name(), ipAddress);
            }
            catch (CloudException e) {
                if (e.body().code().equalsIgnoreCase("PrivateIPAddressNotInAnySubnet")) break block3;
                throw e;
            }
        }
        return result;
    }

    NetworkImpl withSubnet(SubnetImpl subnet) {
        this.subnets.put(subnet.name(), subnet);
        return this;
    }

    @Override
    public NetworkImpl withDnsServer(String ipAddress) {
        if (((VirtualNetworkInner)((Object)this.inner())).dhcpOptions() == null) {
            ((VirtualNetworkInner)((Object)this.inner())).withDhcpOptions(new DhcpOptions());
        }
        if (((VirtualNetworkInner)((Object)this.inner())).dhcpOptions().dnsServers() == null) {
            ((VirtualNetworkInner)((Object)this.inner())).dhcpOptions().withDnsServers(new ArrayList<String>());
        }
        ((VirtualNetworkInner)((Object)this.inner())).dhcpOptions().dnsServers().add(ipAddress);
        return this;
    }

    @Override
    public NetworkImpl withSubnet(String name, String cidr) {
        return this.defineSubnet(name).withAddressPrefix(cidr).attach();
    }

    @Override
    public NetworkImpl withSubnets(Map<String, String> nameCidrPairs) {
        this.subnets.clear();
        for (Map.Entry<String, String> pair : nameCidrPairs.entrySet()) {
            this.withSubnet(pair.getKey(), pair.getValue());
        }
        return this;
    }

    @Override
    public NetworkImpl withoutSubnet(String name) {
        this.subnets.remove(name);
        return this;
    }

    @Override
    public NetworkImpl withAddressSpace(String cidr) {
        if (((VirtualNetworkInner)((Object)this.inner())).addressSpace() == null) {
            ((VirtualNetworkInner)((Object)this.inner())).withAddressSpace(new AddressSpace());
        }
        if (((VirtualNetworkInner)((Object)this.inner())).addressSpace().addressPrefixes() == null) {
            ((VirtualNetworkInner)((Object)this.inner())).addressSpace().withAddressPrefixes(new ArrayList<String>());
        }
        ((VirtualNetworkInner)((Object)this.inner())).addressSpace().addressPrefixes().add(cidr);
        return this;
    }

    public SubnetImpl defineSubnet(String name) {
        SubnetInner inner = new SubnetInner().withName(name);
        return new SubnetImpl(inner, this);
    }

    @Override
    public NetworkImpl withoutAddressSpace(String cidr) {
        if (cidr != null && ((VirtualNetworkInner)((Object)this.inner())).addressSpace() != null && ((VirtualNetworkInner)((Object)this.inner())).addressSpace().addressPrefixes() != null) {
            ((VirtualNetworkInner)((Object)this.inner())).addressSpace().addressPrefixes().remove(cidr);
        }
        return this;
    }

    @Override
    public List<String> addressSpaces() {
        ArrayList addressSpaces = new ArrayList();
        if (((VirtualNetworkInner)((Object)this.inner())).addressSpace() == null) {
            return Collections.unmodifiableList(addressSpaces);
        }
        if (((VirtualNetworkInner)((Object)this.inner())).addressSpace().addressPrefixes() == null) {
            return Collections.unmodifiableList(addressSpaces);
        }
        return Collections.unmodifiableList(((VirtualNetworkInner)((Object)this.inner())).addressSpace().addressPrefixes());
    }

    @Override
    public List<String> dnsServerIPs() {
        ArrayList ips = new ArrayList();
        if (((VirtualNetworkInner)((Object)this.inner())).dhcpOptions() == null) {
            return Collections.unmodifiableList(ips);
        }
        if (((VirtualNetworkInner)((Object)this.inner())).dhcpOptions().dnsServers() == null) {
            return Collections.unmodifiableList(ips);
        }
        return ((VirtualNetworkInner)((Object)this.inner())).dhcpOptions().dnsServers();
    }

    @Override
    public Map<String, Subnet> subnets() {
        return Collections.unmodifiableMap(this.subnets);
    }

    protected void beforeCreating() {
        if (this.addressSpaces().size() == 0) {
            this.withAddressSpace("10.0.0.0/16");
        }
        if (this.isInCreateMode() && this.subnets.size() == 0) {
            this.withSubnet("subnet1", this.addressSpaces().get(0));
        }
        ((VirtualNetworkInner)((Object)this.inner())).withSubnets(this.innersFromWrappers(this.subnets.values()));
    }

    protected void afterCreating() {
        this.initializeChildrenFromInner();
    }

    @Override
    public SubnetImpl updateSubnet(String name) {
        return (SubnetImpl)this.subnets.get(name);
    }

    protected Observable<VirtualNetworkInner> createInner() {
        if (this.ddosProtectionPlanCreatable != null && this.taskResult(this.ddosProtectionPlanCreatable.key()) != null) {
            DdosProtectionPlan ddosProtectionPlan = (DdosProtectionPlan)this.taskResult(this.ddosProtectionPlanCreatable.key());
            this.withExistingDdosProtectionPlan(ddosProtectionPlan.id());
        }
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).virtualNetworks().createOrUpdateAsync(this.resourceGroupName(), this.name(), (VirtualNetworkInner)((Object)this.inner())).map((Func1)new Func1<VirtualNetworkInner, VirtualNetworkInner>(){

            public VirtualNetworkInner call(VirtualNetworkInner virtualNetworkInner) {
                NetworkImpl.this.ddosProtectionPlanCreatable = null;
                return virtualNetworkInner;
            }
        });
    }

    @Override
    public NetworkPeerings peerings() {
        return this.peerings;
    }

    @Override
    public boolean isDdosProtectionEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkInner)((Object)this.inner())).enableDdosProtection());
    }

    @Override
    public boolean isVmProtectionEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((VirtualNetworkInner)((Object)this.inner())).enableVmProtection());
    }

    @Override
    public String ddosProtectionPlanId() {
        return ((VirtualNetworkInner)((Object)this.inner())).ddosProtectionPlan() == null ? null : ((VirtualNetworkInner)((Object)this.inner())).ddosProtectionPlan().id();
    }

    @Override
    public NetworkImpl withNewDdosProtectionPlan() {
        ((VirtualNetworkInner)((Object)this.inner())).withEnableDdosProtection(true);
        DdosProtectionPlan.DefinitionStages.WithGroup ddosProtectionPlanWithGroup = (DdosProtectionPlan.DefinitionStages.WithGroup)((DdosProtectionPlan.DefinitionStages.Blank)((NetworkManager)this.manager()).ddosProtectionPlans().define(SdkContext.randomResourceName((String)this.name(), (int)20))).withRegion(this.region());
        this.ddosProtectionPlanCreatable = this.creatableGroup != null && this.isInCreateMode() ? (Creatable)ddosProtectionPlanWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)ddosProtectionPlanWithGroup.withExistingResourceGroup(this.resourceGroupName());
        this.addDependency(this.ddosProtectionPlanCreatable);
        return this;
    }

    @Override
    public NetworkImpl withExistingDdosProtectionPlan(String planId) {
        ((VirtualNetworkInner)((Object)this.inner())).withEnableDdosProtection(true).withDdosProtectionPlan(new SubResource().withId(planId));
        return this;
    }

    @Override
    public NetworkImpl withoutDdosProtectionPlan() {
        ((VirtualNetworkInner)((Object)this.inner())).withEnableDdosProtection(false).withDdosProtectionPlan(null);
        return this;
    }

    @Override
    public NetworkImpl withVmProtection() {
        ((VirtualNetworkInner)((Object)this.inner())).withEnableVmProtection(true);
        return this;
    }

    @Override
    public NetworkImpl withoutVmProtection() {
        ((VirtualNetworkInner)((Object)this.inner())).withEnableVmProtection(false);
        return this;
    }
}

