/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batchai.ClusterCreateParameters;
import com.microsoft.azure.management.batchai.ClusterUpdateParameters;
import com.microsoft.azure.management.batchai.ClustersListByWorkspaceOptions;
import com.microsoft.azure.management.batchai.ScaleSettings;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.ClusterInner;
import com.microsoft.azure.management.batchai.implementation.PageImpl;
import com.microsoft.azure.management.batchai.implementation.RemoteLoginInformationInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ClustersInner {
    private ClustersService service;
    private BatchAIManagementClientImpl client;

    public ClustersInner(Retrofit retrofit, BatchAIManagementClientImpl client) {
        this.service = (ClustersService)retrofit.create(ClustersService.class);
        this.client = client;
    }

    public ClusterInner create(String resourceGroupName, String workspaceName, String clusterName, ClusterCreateParameters parameters) {
        return (ClusterInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ClusterInner> createAsync(String resourceGroupName, String workspaceName, String clusterName, ClusterCreateParameters parameters, ServiceCallback<ClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName, parameters), serviceCallback);
    }

    public Observable<ClusterInner> createAsync(String resourceGroupName, String workspaceName, String clusterName, ClusterCreateParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName, parameters).map((Func1)new Func1<ServiceResponse<ClusterInner>, ClusterInner>(){

            public ClusterInner call(ServiceResponse<ClusterInner> response) {
                return (ClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ClusterInner>> createWithServiceResponseAsync(String resourceGroupName, String workspaceName, String clusterName, ClusterCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, workspaceName, clusterName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ClusterInner>(){}.getType());
    }

    public ClusterInner beginCreate(String resourceGroupName, String workspaceName, String clusterName, ClusterCreateParameters parameters) {
        return (ClusterInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ClusterInner> beginCreateAsync(String resourceGroupName, String workspaceName, String clusterName, ClusterCreateParameters parameters, ServiceCallback<ClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName, parameters), serviceCallback);
    }

    public Observable<ClusterInner> beginCreateAsync(String resourceGroupName, String workspaceName, String clusterName, ClusterCreateParameters parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName, parameters).map((Func1)new Func1<ServiceResponse<ClusterInner>, ClusterInner>(){

            public ClusterInner call(ServiceResponse<ClusterInner> response) {
                return (ClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ClusterInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String workspaceName, String clusterName, ClusterCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, workspaceName, clusterName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ClusterInner>>>(){

            public Observable<ServiceResponse<ClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ClustersInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ClusterInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ClusterInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ClusterInner update(String resourceGroupName, String workspaceName, String clusterName) {
        return (ClusterInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName).toBlocking().single()).body());
    }

    public ServiceFuture<ClusterInner> updateAsync(String resourceGroupName, String workspaceName, String clusterName, ServiceCallback<ClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName), serviceCallback);
    }

    public Observable<ClusterInner> updateAsync(String resourceGroupName, String workspaceName, String clusterName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName).map((Func1)new Func1<ServiceResponse<ClusterInner>, ClusterInner>(){

            public ClusterInner call(ServiceResponse<ClusterInner> response) {
                return (ClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ClusterInner>> updateWithServiceResponseAsync(String resourceGroupName, String workspaceName, String clusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object scaleSettings = null;
        ClusterUpdateParameters parameters = new ClusterUpdateParameters();
        parameters.withScaleSettings(null);
        return this.service.update(resourceGroupName, workspaceName, clusterName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ClusterInner>>>(){

            public Observable<ServiceResponse<ClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ClustersInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ClusterInner update(String resourceGroupName, String workspaceName, String clusterName, ScaleSettings scaleSettings) {
        return (ClusterInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName, scaleSettings).toBlocking().single()).body());
    }

    public ServiceFuture<ClusterInner> updateAsync(String resourceGroupName, String workspaceName, String clusterName, ScaleSettings scaleSettings, ServiceCallback<ClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName, scaleSettings), serviceCallback);
    }

    public Observable<ClusterInner> updateAsync(String resourceGroupName, String workspaceName, String clusterName, ScaleSettings scaleSettings) {
        return this.updateWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName, scaleSettings).map((Func1)new Func1<ServiceResponse<ClusterInner>, ClusterInner>(){

            public ClusterInner call(ServiceResponse<ClusterInner> response) {
                return (ClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ClusterInner>> updateWithServiceResponseAsync(String resourceGroupName, String workspaceName, String clusterName, ScaleSettings scaleSettings) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)scaleSettings);
        ClusterUpdateParameters parameters = new ClusterUpdateParameters();
        parameters.withScaleSettings(scaleSettings);
        return this.service.update(resourceGroupName, workspaceName, clusterName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ClusterInner>>>(){

            public Observable<ServiceResponse<ClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ClustersInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ClusterInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ClusterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String workspaceName, String clusterName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String workspaceName, String clusterName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String workspaceName, String clusterName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String workspaceName, String clusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, workspaceName, clusterName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String workspaceName, String clusterName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String clusterName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String clusterName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String workspaceName, String clusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, workspaceName, clusterName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ClustersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ClusterInner get(String resourceGroupName, String workspaceName, String clusterName) {
        return (ClusterInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName).toBlocking().single()).body());
    }

    public ServiceFuture<ClusterInner> getAsync(String resourceGroupName, String workspaceName, String clusterName, ServiceCallback<ClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName), serviceCallback);
    }

    public Observable<ClusterInner> getAsync(String resourceGroupName, String workspaceName, String clusterName) {
        return this.getWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName).map((Func1)new Func1<ServiceResponse<ClusterInner>, ClusterInner>(){

            public ClusterInner call(ServiceResponse<ClusterInner> response) {
                return (ClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ClusterInner>> getWithServiceResponseAsync(String resourceGroupName, String workspaceName, String clusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, workspaceName, clusterName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ClusterInner>>>(){

            public Observable<ServiceResponse<ClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ClustersInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ClusterInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ClusterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformation(String resourceGroupName, String workspaceName, String clusterName) {
        ServiceResponse response = (ServiceResponse)this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, workspaceName, clusterName).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>((Page)response.body()){

            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(String resourceGroupName, String workspaceName, String clusterName, ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, workspaceName, clusterName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                return ClustersInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(String resourceGroupName, String workspaceName, String clusterName) {
        return this.listRemoteLoginInformationWithServiceResponseAsync(resourceGroupName, workspaceName, clusterName).map((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>(){

            public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationWithServiceResponseAsync(String resourceGroupName, String workspaceName, String clusterName) {
        return this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, workspaceName, clusterName).concatMap((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationSinglePageAsync(String resourceGroupName, String workspaceName, String clusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listRemoteLoginInformation(resourceGroupName, workspaceName, clusterName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listRemoteLoginInformationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ClusterInner> listByWorkspace(String resourceGroupName, String workspaceName) {
        ServiceResponse response = (ServiceResponse)this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName).toBlocking().single();
        return new PagedList<ClusterInner>((Page)response.body()){

            public Page<ClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ClusterInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName, ListOperationCallback<ClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(String nextPageLink) {
                return ClustersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ClusterInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName) {
        return this.listByWorkspaceWithServiceResponseAsync(resourceGroupName, workspaceName).map((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Page<ClusterInner>>(){

            public Page<ClusterInner> call(ServiceResponse<Page<ClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByWorkspaceWithServiceResponseAsync(String resourceGroupName, String workspaceName) {
        return this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName).concatMap((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(ServiceResponse<Page<ClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByWorkspaceSinglePageAsync(String resourceGroupName, String workspaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object clustersListByWorkspaceOptions = null;
        Integer maxResults = null;
        return this.service.listByWorkspace(resourceGroupName, workspaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listByWorkspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ClusterInner> listByWorkspace(String resourceGroupName, String workspaceName, ClustersListByWorkspaceOptions clustersListByWorkspaceOptions) {
        ServiceResponse response = (ServiceResponse)this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, clustersListByWorkspaceOptions).toBlocking().single();
        return new PagedList<ClusterInner>((Page)response.body()){

            public Page<ClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ClusterInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName, ClustersListByWorkspaceOptions clustersListByWorkspaceOptions, ListOperationCallback<ClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, clustersListByWorkspaceOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(String nextPageLink) {
                return ClustersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ClusterInner>> listByWorkspaceAsync(String resourceGroupName, String workspaceName, ClustersListByWorkspaceOptions clustersListByWorkspaceOptions) {
        return this.listByWorkspaceWithServiceResponseAsync(resourceGroupName, workspaceName, clustersListByWorkspaceOptions).map((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Page<ClusterInner>>(){

            public Page<ClusterInner> call(ServiceResponse<Page<ClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByWorkspaceWithServiceResponseAsync(String resourceGroupName, String workspaceName, ClustersListByWorkspaceOptions clustersListByWorkspaceOptions) {
        return this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, clustersListByWorkspaceOptions).concatMap((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(ServiceResponse<Page<ClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByWorkspaceSinglePageAsync(String resourceGroupName, String workspaceName, ClustersListByWorkspaceOptions clustersListByWorkspaceOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)clustersListByWorkspaceOptions);
        Integer maxResults = null;
        if (clustersListByWorkspaceOptions != null) {
            maxResults = clustersListByWorkspaceOptions.maxResults();
        }
        return this.service.listByWorkspace(resourceGroupName, workspaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listByWorkspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ClusterInner>> listByWorkspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformationNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>((Page)response.body()){

            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(String nextPageLink, ServiceFuture<List<RemoteLoginInformationInner>> serviceFuture, ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                return ClustersInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(String nextPageLink) {
        return this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>(){

            public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextWithServiceResponseAsync(String nextPageLink) {
        return this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listRemoteLoginInformationNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listRemoteLoginInformationNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ClusterInner> listByWorkspaceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ClusterInner>((Page)response.body()){

            public Page<ClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ClusterInner>> listByWorkspaceNextAsync(String nextPageLink, ServiceFuture<List<ClusterInner>> serviceFuture, ListOperationCallback<ClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByWorkspaceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(String nextPageLink) {
                return ClustersInner.this.listByWorkspaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ClusterInner>> listByWorkspaceNextAsync(String nextPageLink) {
        return this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Page<ClusterInner>>(){

            public Page<ClusterInner> call(ServiceResponse<Page<ClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByWorkspaceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByWorkspaceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(ServiceResponse<Page<ClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listByWorkspaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByWorkspaceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByWorkspaceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listByWorkspaceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ClusterInner>> listByWorkspaceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ClustersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="clusterName") String var3, @Path(value="subscriptionId") String var4, @Body ClusterCreateParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="clusterName") String var3, @Path(value="subscriptionId") String var4, @Body ClusterCreateParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="clusterName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ClusterUpdateParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="clusterName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="clusterName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="clusterName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters listRemoteLoginInformation"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters/{clusterName}/listRemoteLoginInformation")
        public Observable<Response<ResponseBody>> listRemoteLoginInformation(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="clusterName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters listByWorkspace"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/clusters")
        public Observable<Response<ResponseBody>> listByWorkspace(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="maxresults") Integer var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters listRemoteLoginInformationNext"})
        @GET
        public Observable<Response<ResponseBody>> listRemoteLoginInformationNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters listByWorkspaceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByWorkspaceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

