/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.utils;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.rest.RestException;
import java.io.IOException;
import java.util.ArrayList;
import rx.Observable;
import rx.functions.Func1;

public abstract class PagedListConverter<U, V> {
    public abstract Observable<V> typeConvertAsync(U var1);

    protected boolean filter(U u) {
        return true;
    }

    public PagedList<V> convert(final PagedList<U> uList) {
        if (uList == null || uList.isEmpty()) {
            return new PagedList<V>(){

                public Page<V> nextPage(String s) throws RestException, IOException {
                    return null;
                }
            };
        }
        Page uPage = uList.currentPage();
        PageImpl vPage = new PageImpl();
        vPage.setNextPageLink(uPage.nextPageLink());
        vPage.setItems(new ArrayList());
        this.loadConvertedList(uPage, vPage);
        return new PagedList<V>(vPage){

            public Page<V> nextPage(String nextPageLink) throws RestException, IOException {
                Page uPage = uList.nextPage(nextPageLink);
                PageImpl vPage = new PageImpl();
                vPage.setNextPageLink(uPage.nextPageLink());
                vPage.setItems(new ArrayList());
                PagedListConverter.this.loadConvertedList(uPage, vPage);
                return vPage;
            }
        };
    }

    private void loadConvertedList(Page<U> uPage, final Page<V> vPage) {
        Observable.from((Iterable)uPage.items()).filter(new Func1<U, Boolean>(){

            public Boolean call(U u) {
                return PagedListConverter.this.filter(u);
            }
        }).flatMap(new Func1<U, Observable<V>>(){

            public Observable<V> call(U u) {
                return PagedListConverter.this.typeConvertAsync(u);
            }
        }).map(new Func1<V, V>(){

            public V call(V v) {
                vPage.items().add(v);
                return v;
            }
        }).toBlocking().subscribe();
    }
}

