/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.compute.AvailabilitySets;
import com.microsoft.azure.management.compute.ComputeSkus;
import com.microsoft.azure.management.compute.ComputeUsages;
import com.microsoft.azure.management.compute.Disks;
import com.microsoft.azure.management.compute.Galleries;
import com.microsoft.azure.management.compute.GalleryImageVersions;
import com.microsoft.azure.management.compute.GalleryImages;
import com.microsoft.azure.management.compute.Snapshots;
import com.microsoft.azure.management.compute.VirtualMachineCustomImages;
import com.microsoft.azure.management.compute.VirtualMachineExtensionImages;
import com.microsoft.azure.management.compute.VirtualMachineImages;
import com.microsoft.azure.management.compute.VirtualMachineScaleSets;
import com.microsoft.azure.management.compute.VirtualMachines;
import com.microsoft.azure.management.compute.implementation.AvailabilitySetsImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeSkusImpl;
import com.microsoft.azure.management.compute.implementation.ComputeUsagesImpl;
import com.microsoft.azure.management.compute.implementation.DisksImpl;
import com.microsoft.azure.management.compute.implementation.GalleriesImpl;
import com.microsoft.azure.management.compute.implementation.GalleryImageVersionsImpl;
import com.microsoft.azure.management.compute.implementation.GalleryImagesImpl;
import com.microsoft.azure.management.compute.implementation.SnapshotsImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineCustomImagesImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionImagesImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImagesImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachinePublishersImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetsImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachinesImpl;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

public final class ComputeManager
extends Manager<ComputeManager, ComputeManagementClientImpl> {
    private StorageManager storageManager;
    private NetworkManager networkManager;
    private GraphRbacManager rbacManager;
    private AvailabilitySets availabilitySets;
    private VirtualMachines virtualMachines;
    private VirtualMachineImages virtualMachineImages;
    private VirtualMachineExtensionImages virtualMachineExtensionImages;
    private VirtualMachineScaleSets virtualMachineScaleSets;
    private ComputeUsages computeUsages;
    private VirtualMachineCustomImages virtualMachineCustomImages;
    private Disks disks;
    private Snapshots snapshots;
    private ComputeSkus computeSkus;
    private Galleries galleries;
    private GalleryImages galleryImages;
    private GalleryImageVersions galleryImageVersions;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static ComputeManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new ComputeManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), subscriptionId);
    }

    public static ComputeManager authenticate(RestClient restClient, String subscriptionId) {
        return new ComputeManager(restClient, subscriptionId);
    }

    private ComputeManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new ComputeManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
        this.storageManager = StorageManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.networkManager = NetworkManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.rbacManager = GraphRbacManager.authenticate((RestClient)restClient, (String)((AzureTokenCredentials)restClient.credentials()).domain());
    }

    public AvailabilitySets availabilitySets() {
        if (this.availabilitySets == null) {
            this.availabilitySets = new AvailabilitySetsImpl(this);
        }
        return this.availabilitySets;
    }

    public VirtualMachines virtualMachines() {
        if (this.virtualMachines == null) {
            this.virtualMachines = new VirtualMachinesImpl(this, this.storageManager, this.networkManager, this.rbacManager);
        }
        return this.virtualMachines;
    }

    public VirtualMachineImages virtualMachineImages() {
        if (this.virtualMachineImages == null) {
            this.virtualMachineImages = new VirtualMachineImagesImpl(new VirtualMachinePublishersImpl(((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineImages(), ((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineExtensionImages()), ((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineImages());
        }
        return this.virtualMachineImages;
    }

    public VirtualMachineExtensionImages virtualMachineExtensionImages() {
        if (this.virtualMachineExtensionImages == null) {
            this.virtualMachineExtensionImages = new VirtualMachineExtensionImagesImpl(new VirtualMachinePublishersImpl(((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineImages(), ((ComputeManagementClientImpl)((Object)this.innerManagementClient)).virtualMachineExtensionImages()));
        }
        return this.virtualMachineExtensionImages;
    }

    public VirtualMachineScaleSets virtualMachineScaleSets() {
        if (this.virtualMachineScaleSets == null) {
            this.virtualMachineScaleSets = new VirtualMachineScaleSetsImpl(this, this.storageManager, this.networkManager, this.rbacManager);
        }
        return this.virtualMachineScaleSets;
    }

    public ComputeUsages usages() {
        if (this.computeUsages == null) {
            this.computeUsages = new ComputeUsagesImpl((ComputeManagementClientImpl)((Object)this.innerManagementClient));
        }
        return this.computeUsages;
    }

    public VirtualMachineCustomImages virtualMachineCustomImages() {
        if (this.virtualMachineCustomImages == null) {
            this.virtualMachineCustomImages = new VirtualMachineCustomImagesImpl(this);
        }
        return this.virtualMachineCustomImages;
    }

    public Disks disks() {
        if (this.disks == null) {
            this.disks = new DisksImpl(this);
        }
        return this.disks;
    }

    public Snapshots snapshots() {
        if (this.snapshots == null) {
            this.snapshots = new SnapshotsImpl(this);
        }
        return this.snapshots;
    }

    public ComputeSkus computeSkus() {
        if (this.computeSkus == null) {
            this.computeSkus = new ComputeSkusImpl(this);
        }
        return this.computeSkus;
    }

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public Galleries galleries() {
        if (this.galleries == null) {
            this.galleries = new GalleriesImpl(this);
        }
        return this.galleries;
    }

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public GalleryImages galleryImages() {
        if (this.galleryImages == null) {
            this.galleryImages = new GalleryImagesImpl(this);
        }
        return this.galleryImages;
    }

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public GalleryImageVersions galleryImageVersions() {
        if (this.galleryImageVersions == null) {
            this.galleryImageVersions = new GalleryImageVersionsImpl(this);
        }
        return this.galleryImageVersions;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public ComputeManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return ComputeManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public ComputeManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

