/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.DataMaskingRuleInner;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DataMaskingRulesInner {
    private DataMaskingRulesService service;
    private SqlManagementClientImpl client;

    public DataMaskingRulesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (DataMaskingRulesService)retrofit.create(DataMaskingRulesService.class);
        this.client = client;
    }

    public DataMaskingRuleInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, String dataMaskingRuleName, DataMaskingRuleInner parameters) {
        return (DataMaskingRuleInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, dataMaskingRuleName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<DataMaskingRuleInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String dataMaskingRuleName, DataMaskingRuleInner parameters, ServiceCallback<DataMaskingRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, dataMaskingRuleName, parameters), serviceCallback);
    }

    public Observable<DataMaskingRuleInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String dataMaskingRuleName, DataMaskingRuleInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, dataMaskingRuleName, parameters).map((Func1)new Func1<ServiceResponse<DataMaskingRuleInner>, DataMaskingRuleInner>(){

            public DataMaskingRuleInner call(ServiceResponse<DataMaskingRuleInner> response) {
                return (DataMaskingRuleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DataMaskingRuleInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String dataMaskingRuleName, DataMaskingRuleInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (dataMaskingRuleName == null) {
            throw new IllegalArgumentException("Parameter dataMaskingRuleName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String dataMaskingPolicyName = "Default";
        String apiVersion = "2014-04-01";
        return this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "Default", dataMaskingRuleName, "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DataMaskingRuleInner>>>(){

            public Observable<ServiceResponse<DataMaskingRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DataMaskingRulesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DataMaskingRuleInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DataMaskingRuleInner>(){}.getType()).register(201, new TypeToken<DataMaskingRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<DataMaskingRuleInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        return (List)((ServiceResponse)this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<DataMaskingRuleInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<List<DataMaskingRuleInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<List<DataMaskingRuleInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<List<DataMaskingRuleInner>>, List<DataMaskingRuleInner>>(){

            public List<DataMaskingRuleInner> call(ServiceResponse<List<DataMaskingRuleInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<DataMaskingRuleInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String dataMaskingPolicyName = "Default";
        String apiVersion = "2014-04-01";
        return this.service.listByDatabase(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "Default", "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<DataMaskingRuleInner>>>>(){

            public Observable<ServiceResponse<List<DataMaskingRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DataMaskingRulesInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DataMaskingRuleInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DataMaskingRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DataMaskingRulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DataMaskingRules createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/dataMaskingPolicies/{dataMaskingPolicyName}/rules/{dataMaskingRuleName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="dataMaskingPolicyName") String var5, @Path(value="dataMaskingRuleName") String var6, @Query(value="api-version") String var7, @Body DataMaskingRuleInner var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DataMaskingRules listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/dataMaskingPolicies/{dataMaskingPolicyName}/rules")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="dataMaskingPolicyName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

