/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.header;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.common.KeyBuilder;

public class ExtraInfoUtil {
    private static final String NORMAL_TOPIC = "0";
    public static final String RETRY_TOPIC = "1";
    private static final String QUEUE_OFFSET = "qo";

    public static String[] split(String extraInfo) {
        if (extraInfo == null) {
            throw new IllegalArgumentException("split extraInfo is null");
        }
        return extraInfo.split(" ");
    }

    public static Long getCkQueueOffset(String[] extraInfoStrs) {
        if (extraInfoStrs == null || extraInfoStrs.length < 1) {
            throw new IllegalArgumentException("getCkQueueOffset fail, extraInfoStrs length " + (extraInfoStrs == null ? 0 : extraInfoStrs.length));
        }
        return Long.valueOf(extraInfoStrs[0]);
    }

    public static Long getPopTime(String[] extraInfoStrs) {
        if (extraInfoStrs == null || extraInfoStrs.length < 2) {
            throw new IllegalArgumentException("getPopTime fail, extraInfoStrs length " + (extraInfoStrs == null ? 0 : extraInfoStrs.length));
        }
        return Long.valueOf(extraInfoStrs[1]);
    }

    public static Long getInvisibleTime(String[] extraInfoStrs) {
        if (extraInfoStrs == null || extraInfoStrs.length < 3) {
            throw new IllegalArgumentException("getInvisibleTime fail, extraInfoStrs length " + (extraInfoStrs == null ? 0 : extraInfoStrs.length));
        }
        return Long.valueOf(extraInfoStrs[2]);
    }

    public static int getReviveQid(String[] extraInfoStrs) {
        if (extraInfoStrs == null || extraInfoStrs.length < 4) {
            throw new IllegalArgumentException("getReviveQid fail, extraInfoStrs length " + (extraInfoStrs == null ? 0 : extraInfoStrs.length));
        }
        return Integer.parseInt(extraInfoStrs[3]);
    }

    public static String getRealTopic(String[] extraInfoStrs, String topic, String cid) {
        if (extraInfoStrs == null || extraInfoStrs.length < 5) {
            throw new IllegalArgumentException("getRealTopic fail, extraInfoStrs length " + (extraInfoStrs == null ? 0 : extraInfoStrs.length));
        }
        if (RETRY_TOPIC.equals(extraInfoStrs[4])) {
            return KeyBuilder.buildPopRetryTopic((String)topic, (String)cid);
        }
        return topic;
    }

    public static String getRealTopic(String topic, String cid, boolean isRetry) {
        return isRetry ? KeyBuilder.buildPopRetryTopic((String)topic, (String)cid) : topic;
    }

    public static String getRetry(String[] extraInfoStrs) {
        if (extraInfoStrs == null || extraInfoStrs.length < 5) {
            throw new IllegalArgumentException("getRetry fail, extraInfoStrs length " + (extraInfoStrs == null ? 0 : extraInfoStrs.length));
        }
        return extraInfoStrs[4];
    }

    public static String getBrokerName(String[] extraInfoStrs) {
        if (extraInfoStrs == null || extraInfoStrs.length < 6) {
            throw new IllegalArgumentException("getBrokerName fail, extraInfoStrs length " + (extraInfoStrs == null ? 0 : extraInfoStrs.length));
        }
        return extraInfoStrs[5];
    }

    public static int getQueueId(String[] extraInfoStrs) {
        if (extraInfoStrs == null || extraInfoStrs.length < 7) {
            throw new IllegalArgumentException("getQueueId fail, extraInfoStrs length " + (extraInfoStrs == null ? 0 : extraInfoStrs.length));
        }
        return Integer.parseInt(extraInfoStrs[6]);
    }

    public static long getQueueOffset(String[] extraInfoStrs) {
        if (extraInfoStrs == null || extraInfoStrs.length < 8) {
            throw new IllegalArgumentException("getQueueOffset fail, extraInfoStrs length " + (extraInfoStrs == null ? 0 : extraInfoStrs.length));
        }
        return Long.parseLong(extraInfoStrs[7]);
    }

    public static String buildExtraInfo(long ckQueueOffset, long popTime, long invisibleTime, int reviveQid, String topic, String brokerName, int queueId) {
        String t = NORMAL_TOPIC;
        if (topic.startsWith("%RETRY%")) {
            t = RETRY_TOPIC;
        }
        return ckQueueOffset + " " + popTime + " " + invisibleTime + " " + reviveQid + " " + t + " " + brokerName + " " + queueId;
    }

    public static String buildExtraInfo(long ckQueueOffset, long popTime, long invisibleTime, int reviveQid, String topic, String brokerName, int queueId, long msgQueueOffset) {
        String t = NORMAL_TOPIC;
        if (topic.startsWith("%RETRY%")) {
            t = RETRY_TOPIC;
        }
        return ckQueueOffset + " " + popTime + " " + invisibleTime + " " + reviveQid + " " + t + " " + brokerName + " " + queueId + " " + msgQueueOffset;
    }

    public static void buildStartOffsetInfo(StringBuilder stringBuilder, boolean retry, int queueId, long startOffset) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(64);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(";");
        }
        stringBuilder.append(retry ? RETRY_TOPIC : NORMAL_TOPIC).append(" ").append(queueId).append(" ").append(startOffset);
    }

    public static void buildQueueIdOrderCountInfo(StringBuilder stringBuilder, boolean retry, int queueId, int orderCount) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(64);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(";");
        }
        stringBuilder.append(retry ? RETRY_TOPIC : NORMAL_TOPIC).append(" ").append(queueId).append(" ").append(orderCount);
    }

    public static void buildQueueOffsetOrderCountInfo(StringBuilder stringBuilder, boolean retry, long queueId, long queueOffset, int orderCount) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(64);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(";");
        }
        stringBuilder.append(retry ? RETRY_TOPIC : NORMAL_TOPIC).append(" ").append(ExtraInfoUtil.getQueueOffsetKeyValueKey(queueId, queueOffset)).append(" ").append(orderCount);
    }

    public static void buildMsgOffsetInfo(StringBuilder stringBuilder, boolean retry, int queueId, List<Long> msgOffsets) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(64);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(";");
        }
        stringBuilder.append(retry ? RETRY_TOPIC : NORMAL_TOPIC).append(" ").append(queueId).append(" ");
        for (int i = 0; i < msgOffsets.size(); ++i) {
            stringBuilder.append(msgOffsets.get(i));
            if (i >= msgOffsets.size() - 1) continue;
            stringBuilder.append(",");
        }
    }

    public static Map<String, List<Long>> parseMsgOffsetInfo(String msgOffsetInfo) {
        if (msgOffsetInfo == null || msgOffsetInfo.length() == 0) {
            return null;
        }
        HashMap<String, List<Long>> msgOffsetMap = new HashMap<String, List<Long>>(4);
        String[] array = msgOffsetInfo.indexOf(";") < 0 ? new String[]{msgOffsetInfo} : msgOffsetInfo.split(";");
        for (String one : array) {
            String[] msgOffsets;
            String[] split = one.split(" ");
            if (split.length != 3) {
                throw new IllegalArgumentException("parse msgOffsetMap error, " + msgOffsetMap);
            }
            String key = split[0] + "@" + split[1];
            if (msgOffsetMap.containsKey(key)) {
                throw new IllegalArgumentException("parse msgOffsetMap error, duplicate, " + msgOffsetMap);
            }
            msgOffsetMap.put(key, new ArrayList(8));
            for (String msgOffset : msgOffsets = split[2].split(",")) {
                ((List)msgOffsetMap.get(key)).add(Long.valueOf(msgOffset));
            }
        }
        return msgOffsetMap;
    }

    public static Map<String, Long> parseStartOffsetInfo(String startOffsetInfo) {
        if (startOffsetInfo == null || startOffsetInfo.length() == 0) {
            return null;
        }
        HashMap<String, Long> startOffsetMap = new HashMap<String, Long>(4);
        String[] array = startOffsetInfo.indexOf(";") < 0 ? new String[]{startOffsetInfo} : startOffsetInfo.split(";");
        for (String one : array) {
            String[] split = one.split(" ");
            if (split.length != 3) {
                throw new IllegalArgumentException("parse startOffsetInfo error, " + startOffsetInfo);
            }
            String key = split[0] + "@" + split[1];
            if (startOffsetMap.containsKey(key)) {
                throw new IllegalArgumentException("parse startOffsetInfo error, duplicate, " + startOffsetInfo);
            }
            startOffsetMap.put(key, Long.valueOf(split[2]));
        }
        return startOffsetMap;
    }

    public static Map<String, Integer> parseOrderCountInfo(String orderCountInfo) {
        if (orderCountInfo == null || orderCountInfo.length() == 0) {
            return null;
        }
        HashMap<String, Integer> startOffsetMap = new HashMap<String, Integer>(4);
        String[] array = orderCountInfo.indexOf(";") < 0 ? new String[]{orderCountInfo} : orderCountInfo.split(";");
        for (String one : array) {
            String[] split = one.split(" ");
            if (split.length != 3) {
                throw new IllegalArgumentException("parse orderCountInfo error, " + orderCountInfo);
            }
            String key = split[0] + "@" + split[1];
            if (startOffsetMap.containsKey(key)) {
                throw new IllegalArgumentException("parse orderCountInfo error, duplicate, " + orderCountInfo);
            }
            startOffsetMap.put(key, Integer.valueOf(split[2]));
        }
        return startOffsetMap;
    }

    public static String getStartOffsetInfoMapKey(String topic, long key) {
        return (topic.startsWith("%RETRY%") ? RETRY_TOPIC : NORMAL_TOPIC) + "@" + key;
    }

    public static String getQueueOffsetKeyValueKey(long queueId, long queueOffset) {
        return QUEUE_OFFSET + queueId + "%" + queueOffset;
    }

    public static String getQueueOffsetMapKey(String topic, long queueId, long queueOffset) {
        return (topic.startsWith("%RETRY%") ? RETRY_TOPIC : NORMAL_TOPIC) + "@" + ExtraInfoUtil.getQueueOffsetKeyValueKey(queueId, queueOffset);
    }

    public static boolean isOrder(String[] extraInfo) {
        return ExtraInfoUtil.getReviveQid(extraInfo) == 999;
    }
}

