/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.file.TieredFileAllocator;
import org.apache.rocketmq.tieredstore.file.TieredFlatFile;
import org.apache.rocketmq.tieredstore.provider.TieredFileSegment;

public class TieredConsumeQueue {
    public static final int CONSUME_QUEUE_STORE_UNIT_SIZE = 20;
    private final TieredFlatFile flatFile;

    public TieredConsumeQueue(TieredFileAllocator fileQueueFactory, String filePath) {
        this.flatFile = fileQueueFactory.createFlatFileForConsumeQueue(filePath);
    }

    public boolean isInitialized() {
        return this.flatFile.getBaseOffset() != -1L;
    }

    @VisibleForTesting
    public TieredFlatFile getFlatFile() {
        return this.flatFile;
    }

    public long getBaseOffset() {
        return this.flatFile.getBaseOffset();
    }

    public void setBaseOffset(long baseOffset) {
        this.flatFile.setBaseOffset(baseOffset);
    }

    public long getMinOffset() {
        return this.flatFile.getMinOffset();
    }

    public long getCommitOffset() {
        return this.flatFile.getCommitOffset();
    }

    public long getMaxOffset() {
        return this.flatFile.getMaxOffset();
    }

    public long getEndTimestamp() {
        return this.flatFile.getFileToWrite().getMaxTimestamp();
    }

    public AppendResult append(long offset, int size, long tagsCode, long timeStamp) {
        return this.append(offset, size, tagsCode, timeStamp, false);
    }

    public AppendResult append(long offset, int size, long tagsCode, long timeStamp, boolean commit) {
        ByteBuffer cqItem = ByteBuffer.allocate(20);
        cqItem.putLong(offset);
        cqItem.putInt(size);
        cqItem.putLong(tagsCode);
        cqItem.flip();
        return this.flatFile.append(cqItem, timeStamp, commit);
    }

    public CompletableFuture<ByteBuffer> readAsync(long offset, int length) {
        return this.flatFile.readAsync(offset, length);
    }

    public void commit(boolean sync) {
        this.flatFile.commit(sync);
    }

    public void cleanExpiredFile(long expireTimestamp) {
        this.flatFile.cleanExpiredFile(expireTimestamp);
    }

    public void destroyExpiredFile() {
        this.flatFile.destroyExpiredFile();
    }

    protected Pair<Long, Long> getQueueOffsetInFileByTime(long timestamp, BoundaryType boundaryType) {
        TieredFileSegment fileSegment = this.flatFile.getFileByTime(timestamp, boundaryType);
        if (fileSegment == null) {
            return Pair.of((Object)-1L, (Object)-1L);
        }
        return Pair.of((Object)(fileSegment.getBaseOffset() / 20L), (Object)(fileSegment.getCommitOffset() / 20L - 1L));
    }

    public void destroy() {
        this.flatFile.destroy();
    }
}

