/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Microsoft.VisualStudio.TestTools.UnitTesting;
using Org.Apache.Rocketmq;

namespace tests
{
    [TestClass]
    public class EndpointsTest
    {
        [TestMethod]
        public void TestGrpcTargetWithoutSsl()
        {
            var endpoints = new Endpoints("127.0.0.1");
            var targetWithoutSsl = endpoints.GrpcTarget(false);
            Assert.AreEqual("http://127.0.0.1:80", targetWithoutSsl);
        }

        [TestMethod]
        public void TestGrpcTargetWithSsl()
        {
            var endpoints = new Endpoints("127.0.0.1");
            var targetWithSsl = endpoints.GrpcTarget(true);
            Assert.AreEqual("https://127.0.0.1:80", targetWithSsl);
        }
    }
}