/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.apis;

import com.google.common.base.Preconditions;
import java.util.Optional;

public class SessionCredentials {
    private final String accessKey;
    private final String accessSecret;
    private final String securityToken;

    public SessionCredentials(String accessKey, String accessSecret, String securityToken) {
        this.accessKey = (String)Preconditions.checkNotNull((Object)accessKey, (Object)"accessKey should not be null");
        this.accessSecret = (String)Preconditions.checkNotNull((Object)accessSecret, (Object)"accessSecret should not be null");
        this.securityToken = (String)Preconditions.checkNotNull((Object)securityToken, (Object)"securityToken should not be null");
    }

    public SessionCredentials(String accessKey, String accessSecret) {
        this.accessKey = (String)Preconditions.checkNotNull((Object)accessKey, (Object)"accessKey should not be null");
        this.accessSecret = (String)Preconditions.checkNotNull((Object)accessSecret, (Object)"accessSecret should not be null");
        this.securityToken = null;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public Optional<String> tryGetSecurityToken() {
        return null == this.securityToken ? Optional.empty() : Optional.of(this.securityToken);
    }
}

