/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.mq;

import java.util.Properties;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.UtilAll;

public class MqPullConsumer {
    private DefaultMQPullConsumer defaultMQPullConsumer = new DefaultMQPullConsumer();

    public MqPullConsumer(Properties properties) {
        this(properties.getProperty("NAMESRV_ADDR"));
    }

    public MqPullConsumer(String nameSrv) {
        this.defaultMQPullConsumer.setNamesrvAddr(nameSrv);
        this.defaultMQPullConsumer.setInstanceName(this.buildInstanceName());
        this.defaultMQPullConsumer.setVipChannelEnabled(false);
    }

    public String buildInstanceName() {
        return Integer.toString(UtilAll.getPid()) + "#" + System.nanoTime();
    }

    public void setConsumerGroup(String consumerGroup) {
        this.defaultMQPullConsumer.setConsumerGroup(consumerGroup);
    }

    public DefaultMQPullConsumer getDefaultMQPullConsumer() {
        return this.defaultMQPullConsumer;
    }

    public void start() {
        try {
            this.defaultMQPullConsumer.start();
        }
        catch (MQClientException e) {
            throw new RuntimeException(e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MqPullConsumer.this.defaultMQPullConsumer.shutdown();
            }
        });
    }
}

