/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.cs.channel.ChannelInfo;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.MqttPacketHandler;
import org.apache.rocketmq.mqtt.cs.session.Session;
import org.apache.rocketmq.mqtt.cs.session.infly.PushAction;
import org.apache.rocketmq.mqtt.cs.session.infly.RetryDriver;
import org.apache.rocketmq.mqtt.cs.session.loop.SessionLoop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MqttPubAckHandler
implements MqttPacketHandler<MqttPubAckMessage> {
    private static Logger logger = LoggerFactory.getLogger(MqttPubAckHandler.class);
    @Resource
    private PushAction pushAction;
    @Resource
    private RetryDriver retryDriver;
    @Resource
    private SessionLoop sessionLoop;

    @Override
    public boolean preHandler(ChannelHandlerContext ctx, MqttPubAckMessage mqttMessage) {
        return true;
    }

    @Override
    public void doHandler(ChannelHandlerContext ctx, MqttPubAckMessage mqttMessage, HookResult upstreamHookResult) {
        int messageId = mqttMessage.variableHeader().messageId();
        this.retryDriver.unMountPublish(messageId, ChannelInfo.getId(ctx.channel()));
        Session session = this.sessionLoop.getSession(ChannelInfo.getId(ctx.channel()));
        this.pushAction.rollNextByAck(session, messageId);
    }
}

