/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.common.hook;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class HookResult {
    public static final int SUCCESS = 200;
    public static final int FAIL = -200;
    private int code;
    private int subCode;
    private String remark;
    private byte[] data;

    public HookResult(int code, int subCode, String remark, byte[] data) {
        this.code = code;
        this.subCode = subCode;
        this.remark = remark;
        this.data = data;
    }

    public HookResult(int code, String remark, byte[] data) {
        this.code = code;
        this.remark = remark;
        this.data = data;
    }

    public static CompletableFuture<HookResult> newHookResult(int code, String remark, byte[] data) {
        CompletableFuture<HookResult> result = new CompletableFuture<HookResult>();
        result.complete(new HookResult(code, remark, data));
        return result;
    }

    public static CompletableFuture<HookResult> newHookResult(int code, int subCode, String remark, byte[] data) {
        CompletableFuture<HookResult> result = new CompletableFuture<HookResult>();
        result.complete(new HookResult(code, subCode, remark, data));
        return result;
    }

    public boolean isSuccess() {
        return 200 == this.code;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getSubCode() {
        return this.subCode;
    }

    public void setSubCode(int subCode) {
        this.subCode = subCode;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HookResult that = (HookResult)o;
        return this.code == that.code && this.subCode == that.subCode && Objects.equals(this.remark, that.remark) && Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = Objects.hash(this.code, this.subCode, this.remark);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

