/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util.timer;

import com.alipay.sofa.jraft.core.Scheduler;
import com.alipay.sofa.jraft.core.TimerManager;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.SPI;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.alipay.sofa.jraft.util.Utils;
import com.alipay.sofa.jraft.util.timer.DefaultTimer;
import com.alipay.sofa.jraft.util.timer.HashedWheelTimer;
import com.alipay.sofa.jraft.util.timer.RaftTimerFactory;
import com.alipay.sofa.jraft.util.timer.Timeout;
import com.alipay.sofa.jraft.util.timer.Timer;
import com.alipay.sofa.jraft.util.timer.TimerTask;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@SPI
public class DefaultRaftTimerFactory
implements RaftTimerFactory {
    private static final String GLOBAL_ELECTION_TIMER_WORKERS = "jraft.timer.global_election_timer_workers";
    private static final String GLOBAL_VOTE_TIMER_WORKERS = "jraft.timer.global_vote_timer_workers";
    private static final String GLOBAL_STEP_DOWN_TIMER_WORKERS = "jraft.timer.global_step_down_timer_workers";
    private static final String GLOBAL_SNAPSHOT_TIMER_WORKERS = "jraft.timer.global_snapshot_timer_workers";
    private static final String GLOBAL_SCHEDULER_WORKERS = "jraft.timer.global_scheduler_workers";
    private static final TimerSharedRef ELECTION_TIMER_REF = new TimerSharedRef(SystemPropertyUtil.getInt("jraft.timer.global_election_timer_workers", Utils.cpus()), "JRaft-Global-ElectionTimer");
    private static final TimerSharedRef VOTE_TIMER_REF = new TimerSharedRef(SystemPropertyUtil.getInt("jraft.timer.global_vote_timer_workers", Utils.cpus()), "JRaft-Global-VoteTimer");
    private static final TimerSharedRef STEP_DOWN_TIMER_REF = new TimerSharedRef(SystemPropertyUtil.getInt("jraft.timer.global_step_down_timer_workers", Utils.cpus()), "JRaft-Global-StepDownTimer");
    private static final TimerSharedRef SNAPSHOT_TIMER_REF = new TimerSharedRef(SystemPropertyUtil.getInt("jraft.timer.global_snapshot_timer_workers", Utils.cpus()), "JRaft-Global-SnapshotTimer");
    private static final SchedulerSharedRef SCHEDULER_REF = new SchedulerSharedRef(SystemPropertyUtil.getInt("jraft.timer.global_scheduler_workers", Utils.cpus() * 3 > 20 ? 20 : Utils.cpus() * 3), "JRaft-Node-ScheduleThreadPool");

    @Override
    public Timer getElectionTimer(boolean shared, String name) {
        return shared ? (Timer)ELECTION_TIMER_REF.getRef() : this.createTimer(name);
    }

    @Override
    public Timer getVoteTimer(boolean shared, String name) {
        return shared ? (Timer)VOTE_TIMER_REF.getRef() : this.createTimer(name);
    }

    @Override
    public Timer getStepDownTimer(boolean shared, String name) {
        return shared ? (Timer)STEP_DOWN_TIMER_REF.getRef() : this.createTimer(name);
    }

    @Override
    public Timer getSnapshotTimer(boolean shared, String name) {
        return shared ? (Timer)SNAPSHOT_TIMER_REF.getRef() : this.createTimer(name);
    }

    @Override
    public Scheduler getRaftScheduler(boolean shared, int workerNum, String name) {
        return shared ? (Scheduler)SCHEDULER_REF.getRef() : this.createScheduler(workerNum, name);
    }

    @Override
    public Timer createTimer(String name) {
        return new HashedWheelTimer(new NamedThreadFactory(name, true), 1L, TimeUnit.MILLISECONDS, 2048);
    }

    @Override
    public Scheduler createScheduler(int workerNum, String name) {
        return new TimerManager(workerNum, name);
    }

    private static class SharedScheduler
    extends Shared<Scheduler>
    implements Scheduler {
        protected SharedScheduler(Scheduler shared) {
            super(shared);
        }

        @Override
        public Scheduler current() {
            return this;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return ((Scheduler)this.shared).schedule(command, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return ((Scheduler)this.shared).scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return ((Scheduler)this.shared).scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }

        @Override
        public void shutdown() {
            if (this.mayShutdown()) {
                ((Scheduler)this.shared).shutdown();
            }
        }
    }

    private static class SchedulerSharedRef
    extends SharedRef<Scheduler> {
        public SchedulerSharedRef(int workerNum, String name) {
            super(workerNum, name);
        }

        @Override
        public Shared<Scheduler> create(int workerNum, String name) {
            return new SharedScheduler(new TimerManager(workerNum, name));
        }
    }

    private static class SharedTimer
    extends Shared<Timer>
    implements Timer {
        protected SharedTimer(Timer shared) {
            super(shared);
        }

        @Override
        public SharedTimer current() {
            return this;
        }

        @Override
        public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
            return ((Timer)this.shared).newTimeout(task, delay, unit);
        }

        @Override
        public Set<Timeout> stop() {
            if (this.mayShutdown()) {
                return ((Timer)this.shared).stop();
            }
            return Collections.emptySet();
        }
    }

    private static class TimerSharedRef
    extends SharedRef<Timer> {
        public TimerSharedRef(int workerNum, String name) {
            super(workerNum, name);
        }

        @Override
        public Shared<Timer> create(int workerNum, String name) {
            return new SharedTimer(new DefaultTimer(workerNum, name));
        }
    }

    private static abstract class SharedRef<T> {
        private final int workerNum;
        private final String name;
        private Shared<T> shared;

        public SharedRef(int workerNum, String name) {
            this.workerNum = workerNum;
            this.name = name;
        }

        public synchronized T getRef() {
            if (this.shared == null || this.shared.isShutdown()) {
                this.shared = this.create(this.workerNum, this.name);
            }
            return this.shared.getRef();
        }

        public abstract Shared<T> create(int var1, String var2);
    }

    private static abstract class Shared<T> {
        private AtomicInteger refCount = new AtomicInteger(0);
        private AtomicBoolean started = new AtomicBoolean(true);
        protected final T shared;

        protected Shared(T shared) {
            this.shared = shared;
        }

        public T getRef() {
            if (this.started.get()) {
                this.refCount.incrementAndGet();
                return this.current();
            }
            throw new IllegalStateException("Shared shutdown");
        }

        public boolean isShutdown() {
            return !this.started.get();
        }

        public abstract T current();

        public boolean mayShutdown() {
            return this.refCount.decrementAndGet() <= 0 && this.started.compareAndSet(true, false);
        }
    }
}

