/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.types;

import flash.swf.SwfEncoder;

public class Matrix {
    public boolean hasScale;
    public int scaleX;
    public int scaleY;
    public boolean hasRotate;
    public int rotateSkew0;
    public int rotateSkew1;
    public int translateX;
    public int translateY;

    public Matrix() {
    }

    public Matrix(int translateX, int translateY) {
        this.translateX = translateX;
        this.translateY = translateY;
    }

    public Matrix(int translateX, int translateY, double scaleX, double scaleY) {
        this.translateX = translateX;
        this.translateY = translateY;
        this.setScale(scaleX, scaleY);
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            if (matrix.hasScale == this.hasScale && matrix.scaleX == this.scaleX && matrix.scaleY == this.scaleY && matrix.hasRotate == this.hasRotate && matrix.rotateSkew0 == this.rotateSkew0 && matrix.rotateSkew1 == this.rotateSkew1 && matrix.translateX == this.translateX && matrix.translateY == this.translateY) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.hasScale) {
            b.append("s");
            b.append((float)((double)this.scaleX / 65536.0)).append(",").append((float)((double)this.scaleY / 65536.0));
            b.append(" ");
        }
        if (this.hasRotate) {
            b.append("r");
            b.append((float)((double)this.rotateSkew0 / 65536.0)).append(",").append((float)((double)this.rotateSkew1 / 65536.0));
            b.append(" ");
        }
        b.append("t");
        b.append(this.translateX).append(",").append(this.translateY);
        return b.toString();
    }

    public int nTranslateBits() {
        return SwfEncoder.minBits(SwfEncoder.maxNum(this.translateX, this.translateY, 0, 0), 1);
    }

    public int nRotateBits() {
        return SwfEncoder.minBits(SwfEncoder.maxNum(this.rotateSkew0, this.rotateSkew1, 0, 0), 1);
    }

    public int nScaleBits() {
        return SwfEncoder.minBits(SwfEncoder.maxNum(this.scaleX, this.scaleY, 0, 0), 1);
    }

    public void setRotate(double r0, double r1) {
        this.hasRotate = true;
        this.rotateSkew0 = (int)(65536.0 * r0);
        this.rotateSkew1 = (int)(65536.0 * r1);
    }

    public void setScale(double x, double y) {
        this.hasScale = true;
        this.scaleX = (int)(65536.0 * x);
        this.scaleY = (int)(65536.0 * y);
    }
}

