/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Creating a sidebar enables you to:
 - create an ordered group of docs
 - render a sidebar for each doc of that group
 - provide next/previous navigation

 The sidebars can be generated from the filesystem, or explicitly defined here.

 Create as many sidebars as you want.
 */

// @ts-check

/** @type {import('@docusaurus/plugin-content-docs').SidebarsConfig} */
const sidebars = {
  // By default, Docusaurus generates a sidebar from the docs folder structure
  // tutorialSidebar: [{type: 'autogenerated', dirName: '.'}],

  // But you can create a sidebar manually
  /*
  tutorialSidebar: [
    {
      type: 'category',
      label: 'Tutorial',
      items: ['hello'],
    },
  ],
   */

  docs: [
    {
      type: 'category',
      label: 'Introduction',
      items: [
        'intro/about',
        'intro/why',
        'intro/history',
      ],
    },
    {
      type: 'category',
      label: 'Quick Start',
      link: {
        type: 'generated-index',
        title: 'Quick Start for SeaTunnel',
        description: 'In this section, you could learn how to get up and running Apache SeaTunnel in both locally or in Docker environment.',
        slug: '/category/start',
        keywords: ['start'],
        image: '/img/favicon.ico',
      },
      items: [
        'start/local',
        'start/docker',
      ],
    },
    {
      type: 'category',
      label: 'Connector',
      items: [
        'connector/config-example',
        {
          type: 'category',
          label: 'Source',
          link: {
            type: 'generated-index',
            title: 'Source of SeaTunnel',
            description: 'List all source supported Apache SeaTunnel for now.',
            slug: '/category/source',
            keywords: ['source'],
            image: '/img/favicon.ico',
          },
          items: [
            {
              type: 'autogenerated',
              dirName: 'connector/source',
            },
          ],
        },
        {
          type: 'category',
          label: 'Sink',
          link: {
            type: 'generated-index',
            title: 'Source of SeaTunnel',
            description: 'List all sink supported Apache SeaTunnel for now.',
            slug: '/category/sink',
            keywords: ['sink'],
            image: '/img/favicon.ico',
          },
          items: [
            {
              type: 'autogenerated',
              dirName: 'connector/sink',
            },
          ],
        },
      ],
    },
    {
      type: 'category',
      label: 'Transform',
      items: [
        'transform/common-options',
        'transform/sql',
        'transform/split',
        'transform/json',
      ],
    },
    {
      type: 'category',
      label: 'Command',
      items: [
        'command/usage',
      ],
    },
    'deployment',
    {
      type: 'category',
      label: 'Contribution',
      items: [
        'contribution/setup',
        'contribution/new-license',
      ],
    },
    'faq',
  ]
};

module.exports = sidebars
