/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.queue;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.collection.LocalQueueStats;
import com.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.hazelcast.collection.impl.queue.QueueContainer;
import com.hazelcast.collection.impl.queue.QueueContainerCollector;
import com.hazelcast.collection.impl.queue.QueueEvent;
import com.hazelcast.collection.impl.queue.QueueEventFilter;
import com.hazelcast.collection.impl.queue.QueueEvictionProcessor;
import com.hazelcast.collection.impl.queue.QueueItem;
import com.hazelcast.collection.impl.queue.QueueProxyImpl;
import com.hazelcast.collection.impl.queue.operations.QueueMergeOperation;
import com.hazelcast.collection.impl.queue.operations.QueueReplicationOperation;
import com.hazelcast.collection.impl.txnqueue.TransactionalQueueProxy;
import com.hazelcast.collection.impl.txnqueue.operations.QueueTransactionRollbackOperation;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.impl.ProviderHelper;
import com.hazelcast.internal.monitor.impl.LocalQueueStatsImpl;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.partition.MigrationAwareService;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.services.SplitBrainHandlerService;
import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.services.TenantContextAwareService;
import com.hazelcast.internal.services.TransactionalService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.scheduler.EntryTaskScheduler;
import com.hazelcast.internal.util.scheduler.EntryTaskSchedulerFactory;
import com.hazelcast.internal.util.scheduler.ScheduleType;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.EventPublishingService;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.impl.merge.AbstractContainerMerger;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.transaction.impl.Transaction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class QueueService
implements ManagedService,
MigrationAwareService,
TransactionalService,
RemoteService,
EventPublishingService<QueueEvent, ItemListener>,
StatisticsAwareService<LocalQueueStats>,
SplitBrainProtectionAwareService,
SplitBrainHandlerService,
DynamicMetricsProvider,
TenantContextAwareService {
    public static final String SERVICE_NAME = "hz:impl:queueService";
    private static final Object NULL_OBJECT = new Object();
    private final ConcurrentMap<String, QueueContainer> containerMap = new ConcurrentHashMap<String, QueueContainer>();
    private final ConcurrentMap<String, LocalQueueStatsImpl> statsMap;
    private final ConstructorFunction<String, LocalQueueStatsImpl> localQueueStatsConstructorFunction = key -> new LocalQueueStatsImpl();
    private final ConcurrentMap<String, Object> splitBrainProtectionConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory splitBrainProtectionConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> splitBrainProtectionConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            QueueConfig queueConfig = QueueService.this.nodeEngine.getConfig().findQueueConfig(name);
            String splitBrainProtectionName = queueConfig.getSplitBrainProtectionName();
            return splitBrainProtectionName == null ? NULL_OBJECT : splitBrainProtectionName;
        }
    };
    private final NodeEngine nodeEngine;
    private final SerializationService serializationService;
    private final IPartitionService partitionService;
    private final ILogger logger;
    private final EntryTaskScheduler<String, Void> queueEvictionScheduler;

    public QueueService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.serializationService = nodeEngine.getSerializationService();
        this.partitionService = nodeEngine.getPartitionService();
        this.logger = nodeEngine.getLogger(QueueService.class);
        TaskScheduler globalScheduler = nodeEngine.getExecutionService().getGlobalTaskScheduler();
        QueueEvictionProcessor entryProcessor = new QueueEvictionProcessor(nodeEngine);
        this.queueEvictionScheduler = EntryTaskSchedulerFactory.newScheduler(globalScheduler, entryProcessor, ScheduleType.POSTPONE);
        int approxQueueCount = nodeEngine.getConfig().getQueueConfigs().size();
        this.statsMap = MapUtil.createConcurrentHashMap(approxQueueCount);
    }

    public void scheduleEviction(String name, long delay) {
        this.queueEvictionScheduler.schedule(delay, name, null);
    }

    public void cancelEviction(String name) {
        this.queueEvictionScheduler.cancel(name);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        boolean dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES);
        if (dsMetricsEnabled) {
            ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    @Override
    public void reset() {
        this.containerMap.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    public QueueContainer getOrCreateContainer(String name, boolean fromBackup) {
        QueueContainer container = (QueueContainer)this.containerMap.get(name);
        if (container != null) {
            return container;
        }
        container = new QueueContainer(name, this.nodeEngine.getConfig().findQueueConfig(name), this.nodeEngine, this);
        QueueContainer existing = this.containerMap.putIfAbsent(name, container);
        if (existing != null) {
            container = existing;
        } else {
            container.init(fromBackup);
            container.getStore().instrument(this.nodeEngine);
        }
        return container;
    }

    public QueueContainer getExistingContainerOrNull(String name) {
        QueueContainer container = (QueueContainer)this.containerMap.get(name);
        return container != null ? container : null;
    }

    public void addContainer(String name, QueueContainer container) {
        this.containerMap.put(name, container);
    }

    public boolean containsQueue(String name) {
        return this.containerMap.containsKey(name);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        HashMap<String, QueueContainer> migrationData = new HashMap<String, QueueContainer>();
        for (Map.Entry entry : this.containerMap.entrySet()) {
            String name = (String)entry.getKey();
            int partitionId = this.partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            QueueContainer container = (QueueContainer)entry.getValue();
            if (partitionId != event.getPartitionId() || container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(event.toString() + ", " + container.toString());
            }
            migrationData.put(name, container);
        }
        return !migrationData.isEmpty() ? new QueueReplicationOperation(migrationData, event.getPartitionId(), event.getReplicaIndex()) : null;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearQueuesHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearQueuesHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearQueuesHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        Iterator iterator2 = this.containerMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            String name = (String)entry.getKey();
            QueueContainer container = (QueueContainer)entry.getValue();
            int containerPartitionId = this.partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            if (containerPartitionId != partitionId || thresholdReplicaIndex >= 0 && thresholdReplicaIndex <= container.getConfig().getTotalBackupCount()) continue;
            container.destroy();
            iterator2.remove();
        }
    }

    @Override
    public void dispatchEvent(QueueEvent event, ItemListener listener) {
        MemberImpl member = this.nodeEngine.getClusterService().getMember(event.caller);
        DataAwareItemEvent itemEvent = new DataAwareItemEvent(event.name, event.eventType, event.data, member, this.serializationService);
        if (member == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Dropping event " + itemEvent + " from unknown address:" + event.caller);
            }
            return;
        }
        if (event.eventType.equals((Object)ItemEventType.ADDED)) {
            listener.itemAdded(itemEvent);
        } else {
            listener.itemRemoved(itemEvent);
        }
        this.getLocalQueueStatsImpl(event.name).incrementReceivedEvents();
    }

    @Override
    public QueueProxyImpl createDistributedObject(String objectId, UUID source, boolean local) {
        QueueConfig queueConfig = this.nodeEngine.getConfig().findQueueConfig(objectId);
        ConfigValidator.checkQueueConfig(queueConfig, this.nodeEngine.getSplitBrainMergePolicyProvider());
        return new QueueProxyImpl(objectId, this, this.nodeEngine, queueConfig);
    }

    @Override
    public void destroyDistributedObject(String name, boolean local) {
        QueueContainer container = (QueueContainer)this.containerMap.remove(name);
        if (container != null) {
            container.destroy();
        }
        this.statsMap.remove(name);
        this.nodeEngine.getEventService().deregisterAllListeners(SERVICE_NAME, name);
        this.splitBrainProtectionConfigCache.remove(name);
    }

    public UUID addLocalItemListener(String name, ItemListener listener, boolean includeValue) {
        EventService eventService = this.nodeEngine.getEventService();
        QueueEventFilter filter2 = new QueueEventFilter(includeValue);
        return eventService.registerLocalListener(SERVICE_NAME, name, filter2, listener).getId();
    }

    public UUID addItemListener(String name, ItemListener listener, boolean includeValue) {
        EventService eventService = this.nodeEngine.getEventService();
        QueueEventFilter filter2 = new QueueEventFilter(includeValue);
        return eventService.registerListener(SERVICE_NAME, name, filter2, listener).getId();
    }

    public CompletableFuture<UUID> addItemListenerAsync(String name, ItemListener listener, boolean includeValue) {
        EventService eventService = this.nodeEngine.getEventService();
        QueueEventFilter filter2 = new QueueEventFilter(includeValue);
        return eventService.registerListenerAsync(SERVICE_NAME, name, filter2, listener).thenApplyAsync(EventRegistration::getId, ConcurrencyUtil.CALLER_RUNS);
    }

    public boolean removeItemListener(String name, UUID registrationId) {
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener(SERVICE_NAME, name, registrationId);
    }

    public CompletableFuture<Boolean> removeItemListenerAsync(String name, UUID registrationId) {
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListenerAsync(SERVICE_NAME, name, registrationId);
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public LocalQueueStats createLocalQueueStats(String name, int partitionId) {
        IPartition partition2;
        Address owner;
        LocalQueueStatsImpl stats = this.getLocalQueueStatsImpl(name);
        stats.setOwnedItemCount(0);
        stats.setBackupItemCount(0);
        QueueContainer container = (QueueContainer)this.containerMap.get(name);
        if (container == null) {
            return stats;
        }
        Address thisAddress = this.nodeEngine.getClusterService().getThisAddress();
        if (thisAddress.equals(owner = (partition2 = this.partitionService.getPartition(partitionId, false)).getOwnerOrNull())) {
            stats.setOwnedItemCount(container.size());
        } else if (owner != null) {
            stats.setBackupItemCount(container.backupSize());
        }
        container.setStats(stats);
        return stats;
    }

    public LocalQueueStats createLocalQueueStats(String name) {
        return this.createLocalQueueStats(name, this.getPartitionId(name));
    }

    public LocalQueueStatsImpl getLocalQueueStatsImpl(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.localQueueStatsConstructorFunction);
    }

    protected ConcurrentMap<String, LocalQueueStatsImpl> getStatsMap() {
        return this.statsMap;
    }

    public TransactionalQueueProxy createTransactionalObject(String name, Transaction transaction) {
        return new TransactionalQueueProxy(this.nodeEngine, this, name, transaction);
    }

    @Override
    public void rollbackTransaction(UUID transactionId) {
        Set queueNames = this.containerMap.keySet();
        OperationService operationService = this.nodeEngine.getOperationService();
        for (String name : queueNames) {
            int partitionId = this.partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            Operation operation = new QueueTransactionRollbackOperation(name, transactionId).setPartitionId(partitionId).setService(this).setNodeEngine(this.nodeEngine);
            operationService.invokeOnPartition(operation);
        }
    }

    @Override
    public Map<String, LocalQueueStats> getStats() {
        Map<String, LocalQueueStats> queueStats = MapUtil.createHashMap(this.containerMap.size());
        for (Map.Entry entry : this.containerMap.entrySet()) {
            String name = (String)entry.getKey();
            QueueContainer queueContainer = (QueueContainer)entry.getValue();
            if (!queueContainer.getConfig().isStatisticsEnabled()) continue;
            LocalQueueStats queueStat = this.createLocalQueueStats(name);
            queueStats.put(name, queueStat);
        }
        return queueStats;
    }

    @Override
    public String getSplitBrainProtectionName(String name) {
        Object splitBrainProtectionName = ConcurrencyUtil.getOrPutSynchronized(this.splitBrainProtectionConfigCache, name, this.splitBrainProtectionConfigCacheMutexFactory, this.splitBrainProtectionConfigConstructor);
        return splitBrainProtectionName == NULL_OBJECT ? null : (String)splitBrainProtectionName;
    }

    @Override
    public Runnable prepareMergeRunnable() {
        QueueContainerCollector collector = new QueueContainerCollector(this.nodeEngine, this.containerMap);
        collector.run();
        return new Merger(collector);
    }

    private int getPartitionId(String name) {
        Object keyData = this.serializationService.toData(name, StringPartitioningStrategy.INSTANCE);
        return this.partitionService.getPartitionId((Data)keyData);
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        ProviderHelper.provide(descriptor, context, "queue", this.getStats());
    }

    public void resetAgeStats(String queueName) {
        QueueContainer queueContainer = (QueueContainer)this.containerMap.get(queueName);
        if (queueContainer != null) {
            queueContainer.resetAgeStats();
        }
    }

    private class Merger
    extends AbstractContainerMerger<QueueContainer, Collection<Object>, SplitBrainMergeTypes.QueueMergeTypes<Object>> {
        Merger(QueueContainerCollector collector) {
            super(collector, QueueService.this.nodeEngine);
        }

        @Override
        protected String getLabel() {
            return "queue";
        }

        @Override
        public void runInternal() {
            for (Map.Entry entry : this.collector.getCollectedContainers().entrySet()) {
                int partitionId = (Integer)entry.getKey();
                Collection containerList = (Collection)entry.getValue();
                for (QueueContainer container : containerList) {
                    Queue<QueueItem> items = container.getItemQueue();
                    String name = container.getName();
                    SplitBrainMergePolicy<Collection<Object>, SplitBrainMergeTypes.QueueMergeTypes<Object>, Collection<Object>> mergePolicy = this.getMergePolicy(container.getConfig().getMergePolicyConfig());
                    SplitBrainMergeTypes.QueueMergeTypes mergingValue = MergingValueFactory.createMergingValue(QueueService.this.serializationService, items);
                    this.sendBatch(partitionId, name, mergePolicy, mergingValue);
                }
            }
        }

        private void sendBatch(int partitionId, String name, SplitBrainMergePolicy<Collection<Object>, SplitBrainMergeTypes.QueueMergeTypes<Object>, Collection<Object>> mergePolicy, SplitBrainMergeTypes.QueueMergeTypes mergingValue) {
            QueueMergeOperation operation = new QueueMergeOperation(name, mergePolicy, mergingValue);
            this.invoke(QueueService.SERVICE_NAME, operation, partitionId);
        }
    }
}

