/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.serializable;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import org.apache.seatunnel.engine.server.operation.CancelJobOperation;
import org.apache.seatunnel.engine.server.operation.GetJobStatusOperation;
import org.apache.seatunnel.engine.server.operation.PrintMessageOperation;
import org.apache.seatunnel.engine.server.operation.SubmitJobOperation;
import org.apache.seatunnel.engine.server.operation.WaitForJobCompleteOperation;
import org.apache.seatunnel.engine.server.task.operation.DeployTaskOperation;

@PrivateApi
public final class OperationDataSerializerHook
implements DataSerializerHook {
    public static final int PRINT_MESSAGE_OPERATOR = 0;
    public static final int SUBMIT_OPERATOR = 1;
    public static final int DEPLOY_TASK_OPERATOR = 2;
    public static final int WAIT_FORM_JOB_COMPLETE_OPERATOR = 3;
    public static final int CANCEL_JOB_OPERATOR = 4;
    public static final int GET_JOB_STATUS_OPERATOR = 5;
    public static final int FACTORY_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.seatunnel.engine.operation", -30001);

    @Override
    public int getFactoryId() {
        return FACTORY_ID;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return new Factory();
    }

    private static class Factory
    implements DataSerializableFactory {
        private Factory() {
        }

        @Override
        public IdentifiedDataSerializable create(int typeId) {
            switch (typeId) {
                case 0: {
                    return new PrintMessageOperation();
                }
                case 1: {
                    return new SubmitJobOperation();
                }
                case 2: {
                    return new DeployTaskOperation();
                }
                case 3: {
                    return new WaitForJobCompleteOperation();
                }
                case 4: {
                    return new CancelJobOperation();
                }
                case 5: {
                    return new GetJobStatusOperation();
                }
            }
            throw new IllegalArgumentException("Unknown type id " + typeId);
        }
    }
}

