/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public class MemoryTierConfig
implements IdentifiedDataSerializable {
    public static final Capacity DEFAULT_CAPACITY = Capacity.of(256L, MemoryUnit.MEGABYTES);
    private Capacity capacity = DEFAULT_CAPACITY;

    public MemoryTierConfig() {
    }

    public MemoryTierConfig(MemoryTierConfig memoryTierConfig) {
        this.capacity = memoryTierConfig.getCapacity();
    }

    public Capacity getCapacity() {
        return this.capacity;
    }

    public MemoryTierConfig setCapacity(Capacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemoryTierConfig)) {
            return false;
        }
        MemoryTierConfig that = (MemoryTierConfig)o;
        return Objects.equals(this.capacity, that.capacity);
    }

    public final int hashCode() {
        return this.capacity != null ? this.capacity.hashCode() : 0;
    }

    public String toString() {
        return "MemoryTierConfig{capacity=" + this.capacity + '}';
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.capacity.getValue());
        out.writeString(this.capacity.getUnit().name());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.capacity = Capacity.of(in.readLong(), MemoryUnit.valueOf(in.readString()));
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 65;
    }
}

