/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.checkpoint.storage.hdfs;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.engine.checkpoint.storage.api.CheckpointStorage;
import org.apache.seatunnel.engine.checkpoint.storage.api.CheckpointStorageFactory;
import org.apache.seatunnel.engine.checkpoint.storage.exception.CheckpointStorageException;
import org.apache.seatunnel.engine.checkpoint.storage.hdfs.common.HdfsFileStorageInstance;

@AutoService(value={Factory.class})
public class HdfsStorageFactory
implements CheckpointStorageFactory {
    @Override
    public String factoryIdentifier() {
        return "hdfs";
    }

    @Override
    public OptionRule optionRule() {
        return OptionRule.builder().build();
    }

    @Override
    public CheckpointStorage create(Map<String, String> configuration) throws CheckpointStorageException {
        if (HdfsFileStorageInstance.isFsNull()) {
            return HdfsFileStorageInstance.getOrCreateStorage(configuration);
        }
        return HdfsFileStorageInstance.getHdfsStorage();
    }
}

