/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.parse;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSinkPluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSourcePluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelTransformPluginDiscovery;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import scala.Serializable;

public class ConnectorInstanceLoader {
    private ConnectorInstanceLoader() {
        throw new IllegalStateException("Utility class");
    }

    public static ImmutablePair<SeaTunnelSource, Set<URL>> loadSourceInstance(Config sourceConfig, JobContext jobContext, List<URL> pluginJars) {
        SeaTunnelSourcePluginDiscovery sourcePluginDiscovery = new SeaTunnelSourcePluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of("seatunnel", "source", sourceConfig.getString("plugin_name"));
        List<URL> pluginJarPaths = sourcePluginDiscovery.getPluginJarPaths(Lists.newArrayList(pluginIdentifier));
        SeaTunnelSource seaTunnelSource = (SeaTunnelSource)sourcePluginDiscovery.createPluginInstance(pluginIdentifier, pluginJars);
        seaTunnelSource.prepare(sourceConfig);
        seaTunnelSource.setJobContext(jobContext);
        if (jobContext.getJobMode() == JobMode.BATCH && seaTunnelSource.getBoundedness() == Boundedness.UNBOUNDED) {
            throw new UnsupportedOperationException(String.format("'%s' source don't support off-line job.", seaTunnelSource.getPluginName()));
        }
        return new ImmutablePair<SeaTunnelSource, Set<URL>>(seaTunnelSource, new HashSet<URL>(pluginJarPaths));
    }

    public static ImmutablePair<SeaTunnelSink<SeaTunnelRow, Serializable, Serializable, Serializable>, Set<URL>> loadSinkInstance(Config sinkConfig, JobContext jobContext, List<URL> pluginJars) {
        SeaTunnelSinkPluginDiscovery sinkPluginDiscovery = new SeaTunnelSinkPluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of("seatunnel", "sink", sinkConfig.getString("plugin_name"));
        List<URL> pluginJarPaths = sinkPluginDiscovery.getPluginJarPaths(Lists.newArrayList(pluginIdentifier));
        SeaTunnelSink seaTunnelSink = (SeaTunnelSink)sinkPluginDiscovery.createPluginInstance(pluginIdentifier, pluginJars);
        seaTunnelSink.prepare(sinkConfig);
        seaTunnelSink.setJobContext(jobContext);
        return new ImmutablePair<SeaTunnelSink<SeaTunnelRow, Serializable, Serializable, Serializable>, Set<URL>>(seaTunnelSink, new HashSet<URL>(pluginJarPaths));
    }

    public static ImmutablePair<SeaTunnelTransform<?>, Set<URL>> loadTransformInstance(Config transformConfig, JobContext jobContext, List<URL> pluginJars) {
        SeaTunnelTransformPluginDiscovery transformPluginDiscovery = new SeaTunnelTransformPluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of("seatunnel", "transform", transformConfig.getString("plugin_name"));
        List<URL> pluginJarPaths = transformPluginDiscovery.getPluginJarPaths(Lists.newArrayList(pluginIdentifier));
        SeaTunnelTransform seaTunnelTransform = (SeaTunnelTransform)transformPluginDiscovery.createPluginInstance(pluginIdentifier, pluginJars);
        seaTunnelTransform.prepare(transformConfig);
        seaTunnelTransform.setJobContext(jobContext);
        return new ImmutablePair(seaTunnelTransform, new HashSet<URL>(pluginJarPaths));
    }
}

