/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform;

import com.google.auto.service.AutoService;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.transform.common.AbstractSeaTunnelTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SeaTunnelTransform.class})
public class FilterFieldTransform
extends AbstractSeaTunnelTransform {
    private static final Logger log = LoggerFactory.getLogger(FilterFieldTransform.class);
    public static final Option<List<String>> KEY_FIELDS = Options.key((String)"fields").listType().noDefaultValue().withDescription("The list of fields that need to be kept. Fields not in the list will be deleted");
    private String[] fields;
    private int[] inputValueIndex;

    public String getPluginName() {
        return "Filter";
    }

    @Override
    protected void setConfig(Config pluginConfig) {
        if (!pluginConfig.hasPath(KEY_FIELDS.key())) {
            throw new IllegalArgumentException("The configuration missing key: " + KEY_FIELDS);
        }
        this.fields = pluginConfig.getStringList(KEY_FIELDS.key()).toArray(new String[0]);
    }

    @Override
    protected SeaTunnelRowType transformRowType(SeaTunnelRowType inputRowType) {
        int[] inputValueIndex = new int[this.fields.length];
        SeaTunnelDataType[] fieldDataTypes = new SeaTunnelDataType[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            String field = this.fields[i];
            int inputFieldIndex = inputRowType.indexOf(field);
            if (inputFieldIndex == -1) {
                throw new IllegalArgumentException("Cannot find [" + field + "] field in input row type");
            }
            fieldDataTypes[i] = inputRowType.getFieldType(inputFieldIndex);
            inputValueIndex[i] = inputFieldIndex;
        }
        SeaTunnelRowType outputRowType = new SeaTunnelRowType(this.fields, fieldDataTypes);
        log.info("Changed input row type: {} to output row type: {}", (Object)inputRowType, (Object)outputRowType);
        this.inputValueIndex = inputValueIndex;
        return outputRowType;
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        Object[] values = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            values[i] = inputRow.getField(this.inputValueIndex[i]);
        }
        return new SeaTunnelRow(values);
    }
}

