/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.AbstractHazelcastCacheManager;
import com.hazelcast.cache.impl.AbstractHazelcastCachingProvider;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import javax.annotation.Nonnull;

public final class HazelcastClientCachingProvider
extends AbstractHazelcastCachingProvider {
    public HazelcastClientCachingProvider() {
    }

    public HazelcastClientCachingProvider(HazelcastInstance instance) {
        this.hazelcastInstance = instance;
    }

    public String toString() {
        return "HazelcastClientCachingProvider{hazelcastInstance=" + this.hazelcastInstance + '}';
    }

    @Override
    protected <T extends AbstractHazelcastCacheManager> T createCacheManager(HazelcastInstance instance, URI uri, ClassLoader classLoader, Properties properties) {
        return (T)new HazelcastClientCacheManager(this, instance, uri, classLoader, properties);
    }

    @Override
    @Nonnull
    protected HazelcastInstance getOrCreateFromUri(@Nonnull URI uri, ClassLoader classLoader, String instanceName) throws URISyntaxException, IOException {
        ClientConfig config = this.getConfigFromLocation(uri, classLoader, instanceName);
        return this.getOrCreateInstanceByConfig(config);
    }

    @Override
    @Nonnull
    protected HazelcastInstance getDefaultInstance() {
        if (this.hazelcastInstance == null) {
            ClientConfig clientConfig = this.getDefaultClientConfig();
            this.hazelcastInstance = StringUtil.isNullOrEmptyAfterTrim(clientConfig.getInstanceName()) ? HazelcastClient.newHazelcastClient() : this.getOrCreateInstanceByConfig(clientConfig);
        }
        return this.hazelcastInstance;
    }

    @Override
    protected HazelcastInstance getOrCreateByInstanceName(String instanceName) {
        HazelcastInstance instance = HazelcastClient.getHazelcastClientByName(instanceName);
        if (instance == null) {
            ClientConfig clientConfig = this.getDefaultClientConfig();
            clientConfig.setInstanceName(instanceName);
            instance = HazelcastClient.newHazelcastClient(clientConfig);
        }
        return instance;
    }

    private ClientConfig getDefaultClientConfig() {
        ClientConfig clientConfig = new XmlClientConfigBuilder().build();
        if (this.namedDefaultHzInstance && StringUtil.isNullOrEmpty(clientConfig.getInstanceName())) {
            clientConfig.setInstanceName("_hzinstance_jcache_shared");
        }
        return clientConfig;
    }

    private ClientConfig getConfigFromLocation(URI location, ClassLoader classLoader, String instanceName) throws URISyntaxException, IOException {
        ClassLoader classLoaderOrDefault = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        URL configURL = this.getConfigURL(location, classLoaderOrDefault);
        try {
            return this.getConfig(configURL, classLoaderOrDefault, instanceName);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private ClientConfig getConfig(URL configURL, ClassLoader theClassLoader, String instanceName) throws IOException {
        ClientConfig config = new XmlClientConfigBuilder(configURL).build().setClassLoader(theClassLoader);
        if (instanceName != null) {
            config.setInstanceName(instanceName);
        } else if (config.getInstanceName() == null) {
            config.setInstanceName(configURL.toString());
        }
        return config;
    }

    private HazelcastInstance getOrCreateInstanceByConfig(ClientConfig config) {
        HazelcastInstance instance = HazelcastClient.getHazelcastClientByName(config.getInstanceName());
        if (instance == null) {
            instance = HazelcastClient.newHazelcastClient(config);
        }
        return instance;
    }
}

