/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.config.NearCachePreloaderConfig;

public final class NearCachePreloaderConfigCodec {
    private static final int ENABLED_FIELD_OFFSET = 0;
    private static final int STORE_INITIAL_DELAY_SECONDS_FIELD_OFFSET = 1;
    private static final int STORE_INTERVAL_SECONDS_FIELD_OFFSET = 5;
    private static final int INITIAL_FRAME_SIZE = 9;

    private NearCachePreloaderConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, NearCachePreloaderConfig nearCachePreloaderConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[9]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, nearCachePreloaderConfig.isEnabled());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 1, nearCachePreloaderConfig.getStoreInitialDelaySeconds());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 5, nearCachePreloaderConfig.getStoreIntervalSeconds());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, nearCachePreloaderConfig.getDirectory());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static NearCachePreloaderConfig decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        boolean enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        int storeInitialDelaySeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 1);
        int storeIntervalSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 5);
        String directory = StringCodec.decode(iterator2);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createNearCachePreloaderConfig(enabled, directory, storeInitialDelaySeconds, storeIntervalSeconds);
    }
}

