/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.cache;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.event.CachePartitionLostEventFilter;
import com.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.hazelcast.cache.impl.event.InternalCachePartitionLostListenerAdapter;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAddListenerMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class CacheAddPartitionLostListenerMessageTask
extends AbstractAddListenerMessageTask<CacheAddPartitionLostListenerCodec.RequestParameters> {
    public CacheAddPartitionLostListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<UUID> processInternal() {
        CachePartitionLostListener listener = event -> {
            if (this.endpoint.isAlive()) {
                ClientMessage eventMessage = CacheAddPartitionLostListenerCodec.encodeCachePartitionLostEvent(event.getPartitionId(), event.getMember().getUuid());
                this.sendClientMessage(null, eventMessage);
            }
        };
        InternalCachePartitionLostListenerAdapter listenerAdapter = new InternalCachePartitionLostListenerAdapter(listener);
        CachePartitionLostEventFilter filter2 = new CachePartitionLostEventFilter();
        CacheService service = (CacheService)this.getService("hz:impl:cacheService");
        EventService eventService = service.getNodeEngine().getEventService();
        if (((CacheAddPartitionLostListenerCodec.RequestParameters)this.parameters).localOnly) {
            return InternalCompletableFuture.newCompletedFuture(eventService.registerLocalListener("hz:impl:cacheService", ((CacheAddPartitionLostListenerCodec.RequestParameters)this.parameters).name, filter2, listenerAdapter).getId());
        }
        return eventService.registerListenerAsync("hz:impl:cacheService", ((CacheAddPartitionLostListenerCodec.RequestParameters)this.parameters).name, filter2, listenerAdapter).thenApplyAsync(EventRegistration::getId, ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    protected CacheAddPartitionLostListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheAddPartitionLostListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return CacheAddPartitionLostListenerCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public String getMethodName() {
        return "addCachePartitionLostListener";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return ((CacheAddPartitionLostListenerCodec.RequestParameters)this.parameters).name;
    }
}

