/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.internal.cluster.ClusterClock;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;

public class ClusterClockImpl
implements ClusterClock {
    private final ILogger logger;
    private volatile long clusterTimeDiff;
    private volatile long clusterStartTime = Long.MIN_VALUE;
    @Probe(name="maxClusterTimeDiff", level=ProbeLevel.MANDATORY, unit=ProbeUnit.MS)
    private volatile long maxClusterTimeDiff;

    public ClusterClockImpl(ILogger logger) {
        this.logger = logger;
    }

    @Override
    @Probe(name="clusterTime", unit=ProbeUnit.MS)
    public long getClusterTime() {
        return Clock.currentTimeMillis() + this.clusterTimeDiff;
    }

    public void setMasterTime(long masterTime) {
        long diff2 = masterTime - Clock.currentTimeMillis();
        this.setClusterTimeDiff(diff2);
    }

    void setClusterTimeDiff(long diff2) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Setting cluster time diff to " + diff2 + "ms.");
        }
        if (Math.abs(diff2) > Math.abs(this.maxClusterTimeDiff)) {
            this.maxClusterTimeDiff = diff2;
        }
        this.clusterTimeDiff = diff2;
    }

    @Probe(name="clusterTimeDiff", level=ProbeLevel.MANDATORY, unit=ProbeUnit.MS)
    long getClusterTimeDiff() {
        return this.clusterTimeDiff;
    }

    @Override
    @Probe(name="clusterUpTime", unit=ProbeUnit.MS)
    public long getClusterUpTime() {
        return Clock.currentTimeMillis() - this.clusterStartTime;
    }

    public void setClusterStartTime(long startTime) {
        if (this.clusterStartTime == Long.MIN_VALUE) {
            this.clusterStartTime = startTime;
        }
    }

    @Probe(name="localClockTime", unit=ProbeUnit.MS)
    private long getLocalClockTime() {
        return Clock.currentTimeMillis();
    }

    @Probe(name="clusterStartTime", unit=ProbeUnit.MS)
    public long getClusterStartTime() {
        return this.clusterStartTime;
    }
}

